/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition.always;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.condition.Condition;

public class AlwaysCondition
implements Condition {
    public static final String TYPE = "always";
    public static final AlwaysCondition INSTANCE = new AlwaysCondition();

    @Override
    public final String type() {
        return TYPE;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().endObject();
    }

    public static AlwaysCondition parse(String watchId, XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("unable to parse [{}] condition for watch [{}]. expected an empty object but found [{}]", new Object[]{TYPE, watchId, parser.currentName()});
        }
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("unable to parse [{}] condition for watch [{}]. expected an empty object but found [{}]", new Object[]{TYPE, watchId, parser.currentName()});
        }
        return INSTANCE;
    }

    public static class Builder
    implements Condition.Builder<AlwaysCondition> {
        public static final Builder INSTANCE = new Builder();

        @Override
        public AlwaysCondition build() {
            return INSTANCE;
        }
    }

    public static class Result
    extends Condition.Result {
        public static final Result INSTANCE = new Result();

        private Result() {
            super(AlwaysCondition.TYPE, true);
        }

        @Override
        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder;
        }
    }
}

