/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.client;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.watcher.transport.actions.ack.AckWatchAction;
import org.elasticsearch.watcher.transport.actions.ack.AckWatchRequest;
import org.elasticsearch.watcher.transport.actions.ack.AckWatchRequestBuilder;
import org.elasticsearch.watcher.transport.actions.ack.AckWatchResponse;
import org.elasticsearch.watcher.transport.actions.activate.ActivateWatchAction;
import org.elasticsearch.watcher.transport.actions.activate.ActivateWatchRequest;
import org.elasticsearch.watcher.transport.actions.activate.ActivateWatchRequestBuilder;
import org.elasticsearch.watcher.transport.actions.activate.ActivateWatchResponse;
import org.elasticsearch.watcher.transport.actions.delete.DeleteWatchAction;
import org.elasticsearch.watcher.transport.actions.delete.DeleteWatchRequest;
import org.elasticsearch.watcher.transport.actions.delete.DeleteWatchRequestBuilder;
import org.elasticsearch.watcher.transport.actions.delete.DeleteWatchResponse;
import org.elasticsearch.watcher.transport.actions.execute.ExecuteWatchAction;
import org.elasticsearch.watcher.transport.actions.execute.ExecuteWatchRequest;
import org.elasticsearch.watcher.transport.actions.execute.ExecuteWatchRequestBuilder;
import org.elasticsearch.watcher.transport.actions.execute.ExecuteWatchResponse;
import org.elasticsearch.watcher.transport.actions.get.GetWatchAction;
import org.elasticsearch.watcher.transport.actions.get.GetWatchRequest;
import org.elasticsearch.watcher.transport.actions.get.GetWatchRequestBuilder;
import org.elasticsearch.watcher.transport.actions.get.GetWatchResponse;
import org.elasticsearch.watcher.transport.actions.put.PutWatchAction;
import org.elasticsearch.watcher.transport.actions.put.PutWatchRequest;
import org.elasticsearch.watcher.transport.actions.put.PutWatchRequestBuilder;
import org.elasticsearch.watcher.transport.actions.put.PutWatchResponse;
import org.elasticsearch.watcher.transport.actions.service.WatcherServiceAction;
import org.elasticsearch.watcher.transport.actions.service.WatcherServiceRequest;
import org.elasticsearch.watcher.transport.actions.service.WatcherServiceRequestBuilder;
import org.elasticsearch.watcher.transport.actions.service.WatcherServiceResponse;
import org.elasticsearch.watcher.transport.actions.stats.WatcherStatsAction;
import org.elasticsearch.watcher.transport.actions.stats.WatcherStatsRequest;
import org.elasticsearch.watcher.transport.actions.stats.WatcherStatsRequestBuilder;
import org.elasticsearch.watcher.transport.actions.stats.WatcherStatsResponse;

public class WatcherClient {
    private final ElasticsearchClient client;

    @Inject
    public WatcherClient(Client client) {
        this.client = client;
    }

    public GetWatchRequestBuilder prepareGetWatch(String id) {
        return new GetWatchRequestBuilder(this.client, id);
    }

    public GetWatchRequestBuilder prepareGetWatch() {
        return new GetWatchRequestBuilder(this.client);
    }

    public void getWatch(GetWatchRequest request, ActionListener<GetWatchResponse> listener) {
        this.client.execute((Action)GetWatchAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<GetWatchResponse> getWatch(GetWatchRequest request) {
        return this.client.execute((Action)GetWatchAction.INSTANCE, (ActionRequest)request);
    }

    public DeleteWatchRequestBuilder prepareDeleteWatch(String id) {
        return new DeleteWatchRequestBuilder(this.client, id);
    }

    public DeleteWatchRequestBuilder prepareDeleteWatch() {
        return new DeleteWatchRequestBuilder(this.client);
    }

    public void deleteWatch(DeleteWatchRequest request, ActionListener<DeleteWatchResponse> listener) {
        this.client.execute((Action)DeleteWatchAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<DeleteWatchResponse> deleteWatch(DeleteWatchRequest request) {
        return this.client.execute((Action)DeleteWatchAction.INSTANCE, (ActionRequest)request);
    }

    public PutWatchRequestBuilder preparePutWatch(String id) {
        return new PutWatchRequestBuilder(this.client, id);
    }

    public PutWatchRequestBuilder preparePutWatch() {
        return new PutWatchRequestBuilder(this.client);
    }

    public void putWatch(PutWatchRequest request, ActionListener<PutWatchResponse> listener) {
        this.client.execute((Action)PutWatchAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<PutWatchResponse> putWatch(PutWatchRequest request) {
        return this.client.execute((Action)PutWatchAction.INSTANCE, (ActionRequest)request);
    }

    public ActionFuture<WatcherStatsResponse> watcherStats(WatcherStatsRequest request) {
        return this.client.execute((Action)WatcherStatsAction.INSTANCE, (ActionRequest)request);
    }

    public WatcherStatsRequestBuilder prepareWatcherStats() {
        return new WatcherStatsRequestBuilder(this.client);
    }

    public void watcherStats(WatcherStatsRequest request, ActionListener<WatcherStatsResponse> listener) {
        this.client.execute((Action)WatcherStatsAction.INSTANCE, (ActionRequest)request, listener);
    }

    public AckWatchRequestBuilder prepareAckWatch(String id) {
        return new AckWatchRequestBuilder(this.client, id);
    }

    public void ackWatch(AckWatchRequest request, ActionListener<AckWatchResponse> listener) {
        this.client.execute((Action)AckWatchAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<AckWatchResponse> ackWatch(AckWatchRequest request) {
        return this.client.execute((Action)AckWatchAction.INSTANCE, (ActionRequest)request);
    }

    public ActivateWatchRequestBuilder prepareActivateWatch(String id, boolean activate) {
        return new ActivateWatchRequestBuilder(this.client, id, activate);
    }

    public void activateWatch(ActivateWatchRequest request, ActionListener<ActivateWatchResponse> listener) {
        this.client.execute((Action)ActivateWatchAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<ActivateWatchResponse> activateWatch(ActivateWatchRequest request) {
        return this.client.execute((Action)ActivateWatchAction.INSTANCE, (ActionRequest)request);
    }

    public WatcherServiceRequestBuilder prepareWatchService() {
        return new WatcherServiceRequestBuilder(this.client);
    }

    public void watcherService(WatcherServiceRequest request, ActionListener<WatcherServiceResponse> listener) {
        this.client.execute((Action)WatcherServiceAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<WatcherServiceResponse> watcherService(WatcherServiceRequest request) {
        return this.client.execute((Action)WatcherServiceAction.INSTANCE, (ActionRequest)request);
    }

    public ExecuteWatchRequestBuilder prepareExecuteWatch(String id) {
        return new ExecuteWatchRequestBuilder(this.client, id);
    }

    public ExecuteWatchRequestBuilder prepareExecuteWatch() {
        return new ExecuteWatchRequestBuilder(this.client);
    }

    public void executeWatch(ExecuteWatchRequest request, ActionListener<ExecuteWatchResponse> listener) {
        this.client.execute((Action)ExecuteWatchAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<ExecuteWatchResponse> executeWatch(ExecuteWatchRequest request) {
        return this.client.execute((Action)ExecuteWatchAction.INSTANCE, (ActionRequest)request);
    }
}

