/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.slack.service;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.watcher.actions.slack.service.SlackAccount;
import org.elasticsearch.watcher.support.http.HttpClient;

public class SlackAccounts {
    private final Map<String, SlackAccount> accounts;
    private final String defaultAccountName;

    public SlackAccounts(Settings settings, HttpClient httpClient, ESLogger logger) {
        Settings accountsSettings = settings.getAsSettings("account");
        this.accounts = new HashMap<String, SlackAccount>();
        for (String name : accountsSettings.names()) {
            Settings accountSettings = accountsSettings.getAsSettings(name);
            SlackAccount account = new SlackAccount(name, accountSettings, settings, httpClient, logger);
            this.accounts.put(name, account);
        }
        String defaultAccountName = settings.get("default_account");
        if (defaultAccountName == null) {
            if (this.accounts.isEmpty()) {
                this.defaultAccountName = null;
            } else {
                SlackAccount account = this.accounts.values().iterator().next();
                logger.info("default slack account set to [{}]", new Object[]{account.name});
                this.defaultAccountName = account.name;
            }
        } else {
            if (!this.accounts.containsKey(defaultAccountName)) {
                throw new SettingsException("could not find default slack account [" + defaultAccountName + "]");
            }
            this.defaultAccountName = defaultAccountName;
        }
    }

    public SlackAccount account(String name) throws IllegalStateException {
        if (name == null) {
            if (this.defaultAccountName == null) {
                throw new IllegalStateException("cannot find default slack account as no accounts have been configured");
            }
            name = this.defaultAccountName;
        }
        return this.accounts.get(name);
    }
}

