/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.slack;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.ActionFactory;
import org.elasticsearch.watcher.actions.hipchat.ExecutableHipChatAction;
import org.elasticsearch.watcher.actions.slack.ExecutableSlackAction;
import org.elasticsearch.watcher.actions.slack.SlackAction;
import org.elasticsearch.watcher.actions.slack.service.SlackAccount;
import org.elasticsearch.watcher.actions.slack.service.SlackService;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;

public class SlackActionFactory
extends ActionFactory<SlackAction, ExecutableSlackAction> {
    private final TextTemplateEngine templateEngine;
    private final SlackService slackService;

    @Inject
    public SlackActionFactory(Settings settings, TextTemplateEngine templateEngine, SlackService slackService) {
        super(Loggers.getLogger(ExecutableHipChatAction.class, (Settings)settings, (String[])new String[0]));
        this.templateEngine = templateEngine;
        this.slackService = slackService;
    }

    @Override
    public String type() {
        return "slack";
    }

    @Override
    public SlackAction parseAction(String watchId, String actionId, XContentParser parser) throws IOException {
        SlackAction action = SlackAction.parse(watchId, actionId, parser);
        SlackAccount account = this.slackService.getAccount(action.account);
        if (account == null) {
            throw new ElasticsearchParseException("could not parse [slack] action [{}/{}]. unknown slack account [{}]", new Object[]{watchId, account, action.account});
        }
        return action;
    }

    @Override
    public ExecutableSlackAction createExecutable(SlackAction action) {
        return new ExecutableSlackAction(action, this.actionLogger, this.slackService, this.templateEngine);
    }
}

