/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.index;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.ActionFactory;
import org.elasticsearch.watcher.actions.email.ExecutableEmailAction;
import org.elasticsearch.watcher.actions.index.ExecutableIndexAction;
import org.elasticsearch.watcher.actions.index.IndexAction;
import org.elasticsearch.watcher.support.init.proxy.ClientProxy;

public class IndexActionFactory
extends ActionFactory<IndexAction, ExecutableIndexAction> {
    private final ClientProxy client;
    private final TimeValue defaultTimeout;

    @Inject
    public IndexActionFactory(Settings settings, ClientProxy client) {
        super(Loggers.getLogger(ExecutableEmailAction.class, (Settings)settings, (String[])new String[0]));
        this.client = client;
        this.defaultTimeout = settings.getAsTime("watcher.actions.index.default_timeout", null);
    }

    @Override
    public String type() {
        return "index";
    }

    @Override
    public IndexAction parseAction(String watchId, String actionId, XContentParser parser) throws IOException {
        return IndexAction.parse(watchId, actionId, parser);
    }

    @Override
    public ExecutableIndexAction createExecutable(IndexAction action) {
        return new ExecutableIndexAction(action, this.actionLogger, this.client, this.defaultTimeout);
    }
}

