/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.hipchat;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.ActionFactory;
import org.elasticsearch.watcher.actions.hipchat.ExecutableHipChatAction;
import org.elasticsearch.watcher.actions.hipchat.HipChatAction;
import org.elasticsearch.watcher.actions.hipchat.service.HipChatAccount;
import org.elasticsearch.watcher.actions.hipchat.service.HipChatService;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;

public class HipChatActionFactory
extends ActionFactory<HipChatAction, ExecutableHipChatAction> {
    private final TextTemplateEngine templateEngine;
    private final HipChatService hipchatService;

    @Inject
    public HipChatActionFactory(Settings settings, TextTemplateEngine templateEngine, HipChatService hipchatService) {
        super(Loggers.getLogger(ExecutableHipChatAction.class, (Settings)settings, (String[])new String[0]));
        this.templateEngine = templateEngine;
        this.hipchatService = hipchatService;
    }

    @Override
    public String type() {
        return "hipchat";
    }

    @Override
    public HipChatAction parseAction(String watchId, String actionId, XContentParser parser) throws IOException {
        HipChatAction action = HipChatAction.parse(watchId, actionId, parser);
        HipChatAccount account = this.hipchatService.getAccount(action.account);
        if (account == null) {
            throw new ElasticsearchParseException("could not parse [hipchat] action [{}/{}]. unknown hipchat account [{}]", new Object[]{watchId, account, action.account});
        }
        account.validateParsedTemplate(watchId, actionId, action.message);
        return action;
    }

    @Override
    public ExecutableHipChatAction createExecutable(HipChatAction action) {
        return new ExecutableHipChatAction(action, this.actionLogger, this.hipchatService, this.templateEngine);
    }
}

