/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.email.service;

import java.io.IOException;
import java.nio.file.Path;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.watcher.actions.email.service.support.BodyPartSource;

public abstract class Attachment
extends BodyPartSource {
    protected Attachment(String id, String name, String contentType) {
        super(id, name, contentType);
    }

    @Override
    public final MimeBodyPart bodyPart() throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setContentID(this.id);
        part.setFileName(this.name);
        part.setDisposition("attachment");
        this.writeTo(part);
        return part;
    }

    public abstract String type();

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("type", this.type()).field("id", this.id).field("name", this.name).field("content_type", this.contentType).endObject();
    }

    protected abstract void writeTo(MimeBodyPart var1) throws MessagingException;

    public static class XContent
    extends Bytes {
        protected XContent(String id, ToXContent content, XContentType type) {
            this(id, id, content, type);
        }

        protected XContent(String id, String name, ToXContent content, XContentType type) {
            super(id, name, XContent.bytes(name, content, type), XContent.mimeType(type));
        }

        static String mimeType(XContentType type) {
            switch (type) {
                case JSON: {
                    return "application/json";
                }
                case YAML: {
                    return "application/yaml";
                }
                case SMILE: {
                    return "application/smile";
                }
                case CBOR: {
                    return "application/cbor";
                }
            }
            throw new IllegalArgumentException("unsupported xcontent attachment type [" + type.name() + "]");
        }

        static byte[] bytes(String name, ToXContent content, XContentType type) {
            try {
                XContentBuilder builder = XContentBuilder.builder((org.elasticsearch.common.xcontent.XContent)type.xContent()).prettyPrint();
                content.toXContent(builder, ToXContent.EMPTY_PARAMS);
                return builder.bytes().toBytes();
            }
            catch (IOException ioe) {
                throw new ElasticsearchException("could not create an xcontent attachment [" + name + "]", (Throwable)ioe, new Object[0]);
            }
        }

        public static class Json
        extends XContent {
            public Json(String id, ToXContent content) {
                super(id, content, XContentType.JSON);
            }

            public Json(String id, String name, ToXContent content) {
                super(id, name, content, XContentType.JSON);
            }

            @Override
            public String type() {
                return "json";
            }
        }

        public static class Yaml
        extends XContent {
            public Yaml(String id, ToXContent content) {
                super(id, content, XContentType.YAML);
            }

            public Yaml(String id, String name, ToXContent content) {
                super(id, name, content, XContentType.YAML);
            }

            @Override
            public String type() {
                return "yaml";
            }
        }
    }

    public static class Bytes
    extends Attachment {
        static final String TYPE = "bytes";
        private final byte[] bytes;

        public Bytes(String id, byte[] bytes, String contentType) {
            this(id, id, bytes, contentType);
        }

        public Bytes(String id, String name, byte[] bytes) {
            this(id, name, bytes, fileTypeMap.getContentType(name));
        }

        public Bytes(String id, String name, byte[] bytes, String contentType) {
            super(id, name, contentType);
            this.bytes = bytes;
        }

        @Override
        public String type() {
            return TYPE;
        }

        public byte[] bytes() {
            return this.bytes;
        }

        @Override
        public void writeTo(MimeBodyPart part) throws MessagingException {
            ByteArrayDataSource dataSource = new ByteArrayDataSource(this.bytes, this.contentType);
            DataHandler handler = new DataHandler((DataSource)dataSource);
            part.setDataHandler(handler);
        }
    }

    public static class File
    extends Attachment {
        static final String TYPE = "file";
        private final Path path;
        private final DataSource dataSource;

        public File(String id, Path path) {
            this(id, path.getFileName().toString(), path);
        }

        public File(String id, Path path, String contentType) {
            this(id, path.getFileName().toString(), path, contentType);
        }

        @SuppressForbidden(reason="uses toFile")
        public File(String id, String name, Path path) {
            this(id, name, path, fileTypeMap.getContentType(path.toFile()));
        }

        @SuppressForbidden(reason="uses toFile")
        public File(String id, String name, Path path, String contentType) {
            super(id, name, contentType);
            this.path = path;
            this.dataSource = new FileDataSource(path.toFile());
        }

        public Path path() {
            return this.path;
        }

        @Override
        public String type() {
            return TYPE;
        }

        @Override
        public void writeTo(MimeBodyPart part) throws MessagingException {
            part.setDataHandler(new DataHandler(this.dataSource));
        }
    }
}

