/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.email.service;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.watcher.actions.email.service.Account;
import org.elasticsearch.watcher.support.secret.SecretService;

public class Accounts {
    private final String defaultAccountName;
    private final Map<String, Account> accounts;

    public Accounts(Settings settings, SecretService secretService, ESLogger logger) {
        Settings accountsSettings = settings.getAsSettings("account");
        this.accounts = new HashMap<String, Account>();
        for (String name : accountsSettings.names()) {
            Account.Config config = new Account.Config(name, accountsSettings.getAsSettings(name));
            Account account = new Account(config, secretService, logger);
            this.accounts.put(name, account);
        }
        String defaultAccountName = settings.get("default_account");
        if (defaultAccountName == null) {
            if (this.accounts.isEmpty()) {
                this.defaultAccountName = null;
            } else {
                Account account = this.accounts.values().iterator().next();
                logger.info("default account set to [{}]", new Object[]{account.name()});
                this.defaultAccountName = account.name();
            }
        } else {
            if (!this.accounts.containsKey(defaultAccountName)) {
                throw new SettingsException("could not find default email account [" + defaultAccountName + "]");
            }
            this.defaultAccountName = defaultAccountName;
        }
    }

    public Account account(String name) throws IllegalStateException {
        if (name == null) {
            if (this.defaultAccountName == null) {
                throw new IllegalStateException("cannot find default email account as no accounts have been configured");
            }
            name = this.defaultAccountName;
        }
        return this.accounts.get(name);
    }
}

