/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.email;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.watcher.actions.Action;
import org.elasticsearch.watcher.actions.ExecutableAction;
import org.elasticsearch.watcher.actions.email.DataAttachment;
import org.elasticsearch.watcher.actions.email.EmailAction;
import org.elasticsearch.watcher.actions.email.service.Attachment;
import org.elasticsearch.watcher.actions.email.service.Email;
import org.elasticsearch.watcher.actions.email.service.EmailService;
import org.elasticsearch.watcher.actions.email.service.HtmlSanitizer;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.support.Variables;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;
import org.elasticsearch.watcher.watch.Payload;

public class ExecutableEmailAction
extends ExecutableAction<EmailAction> {
    final EmailService emailService;
    final TextTemplateEngine templateEngine;
    final HtmlSanitizer htmlSanitizer;

    public ExecutableEmailAction(EmailAction action, ESLogger logger, EmailService emailService, TextTemplateEngine templateEngine, HtmlSanitizer htmlSanitizer) {
        super(action, logger);
        this.emailService = emailService;
        this.templateEngine = templateEngine;
        this.htmlSanitizer = htmlSanitizer;
    }

    @Override
    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        Map<String, Object> model = Variables.createCtxModel(ctx, payload);
        HashMap<String, Attachment> attachments = new HashMap<String, Attachment>();
        DataAttachment dataAttachment = ((EmailAction)this.action).getDataAttachment();
        if (dataAttachment != null) {
            Attachment attachment = dataAttachment.create(model);
            attachments.put(attachment.id(), attachment);
        }
        Email.Builder email = ((EmailAction)this.action).getEmail().render(this.templateEngine, model, this.htmlSanitizer, attachments);
        email.id(ctx.id().value());
        if (ctx.simulateAction(actionId)) {
            return new EmailAction.Result.Simulated(email.build());
        }
        EmailService.EmailSent sent = this.emailService.send(email.build(), ((EmailAction)this.action).getAuth(), ((EmailAction)this.action).getProfile(), ((EmailAction)this.action).getAccount());
        return new EmailAction.Result.Success(sent.account(), sent.email());
    }
}

