/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.watcher.actions.Action;
import org.elasticsearch.watcher.actions.ActionWrapper;

public class ExecutableActions
implements Iterable<ActionWrapper>,
ToXContent {
    private final List<ActionWrapper> actions;

    public ExecutableActions(List<ActionWrapper> actions) {
        this.actions = actions;
    }

    public int count() {
        return this.actions.size();
    }

    @Override
    public Iterator<ActionWrapper> iterator() {
        return this.actions.iterator();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (ActionWrapper action : this.actions) {
            builder.field(action.id(), (ToXContent)action, params);
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutableActions actions1 = (ExecutableActions)o;
        return this.actions.equals(actions1.actions);
    }

    public int hashCode() {
        return this.actions.hashCode();
    }

    public static class Results
    implements Iterable<ActionWrapper.Result>,
    ToXContent {
        private final Map<String, ActionWrapper.Result> results;

        public Results(Map<String, ActionWrapper.Result> results) {
            this.results = results;
        }

        public int count() {
            return this.results.size();
        }

        @Override
        public Iterator<ActionWrapper.Result> iterator() {
            return this.results.values().iterator();
        }

        public ActionWrapper.Result get(String id) {
            return this.results.get(id);
        }

        public boolean throttled() {
            for (ActionWrapper.Result result : this.results.values()) {
                if (result.action().status() != Action.Result.Status.THROTTLED) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Results results1 = (Results)o;
            return this.results.equals(results1.results);
        }

        public int hashCode() {
            return this.results.hashCode();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray();
            for (ActionWrapper.Result result : this.results.values()) {
                result.toXContent(builder, params);
            }
            return builder.endArray();
        }
    }
}

