/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions;

import java.io.IOException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.watcher.actions.Action;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.watch.Payload;

public abstract class ExecutableAction<A extends Action>
implements ToXContent {
    protected final A action;
    protected final ESLogger logger;

    protected ExecutableAction(A action, ESLogger logger) {
        this.action = action;
        this.logger = logger;
    }

    public String type() {
        return this.action.type();
    }

    public A action() {
        return this.action;
    }

    public ESLogger logger() {
        return this.logger;
    }

    public abstract Action.Result execute(String var1, WatchExecutionContext var2, Payload var3) throws Exception;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutableAction that = (ExecutableAction)o;
        return this.action.equals(that.action);
    }

    public int hashCode() {
        return this.action.hashCode();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.action.toXContent(builder, params);
    }
}

