/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.ActionFactory;
import org.elasticsearch.watcher.actions.ActionWrapper;
import org.elasticsearch.watcher.actions.ExecutableActions;
import org.elasticsearch.watcher.license.WatcherLicensee;
import org.elasticsearch.watcher.support.clock.Clock;
import org.elasticsearch.watcher.support.validation.Validation;
import org.elasticsearch.watcher.transform.TransformRegistry;

public class ActionRegistry {
    private final ImmutableMap<String, ActionFactory> parsers;
    private final TransformRegistry transformRegistry;
    private final Clock clock;
    private final WatcherLicensee watcherLicensee;

    @Inject
    public ActionRegistry(Map<String, ActionFactory> parsers, TransformRegistry transformRegistry, Clock clock, WatcherLicensee watcherLicensee) {
        this.parsers = ImmutableMap.copyOf(parsers);
        this.transformRegistry = transformRegistry;
        this.clock = clock;
        this.watcherLicensee = watcherLicensee;
    }

    ActionFactory factory(String type) {
        return (ActionFactory)this.parsers.get((Object)type);
    }

    public ExecutableActions parseActions(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse actions for watch [{}]. expected an object but found [{}] instead", new Object[]{watchId, parser.currentToken()});
        }
        ArrayList<ActionWrapper> actions = new ArrayList<ActionWrapper>();
        String id = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                id = parser.currentName();
                Validation.Error error = Validation.actionId(id);
                if (error == null) continue;
                throw new ElasticsearchParseException("could not parse action [{}] for watch [{}]. {}", new Object[]{id, watchId, error});
            }
            if (token != XContentParser.Token.START_OBJECT || id == null) continue;
            ActionWrapper action = ActionWrapper.parse(watchId, id, parser, this, this.transformRegistry, this.clock, this.watcherLicensee);
            actions.add(action);
        }
        return new ExecutableActions(actions);
    }
}

