/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.watcher.WatcherLifeCycleService;
import org.elasticsearch.watcher.support.WatcherIndexTemplateRegistry;
import org.elasticsearch.watcher.support.validation.WatcherSettingsValidation;

public class WatcherModule
extends AbstractModule {
    public static final String HISTORY_TEMPLATE_NAME = "watch_history";
    public static final String TRIGGERED_TEMPLATE_NAME = "triggered_watches";
    public static final String WATCHES_TEMPLATE_NAME = "watches";
    public static final WatcherIndexTemplateRegistry.TemplateConfig[] TEMPLATE_CONFIGS = new WatcherIndexTemplateRegistry.TemplateConfig[]{new WatcherIndexTemplateRegistry.TemplateConfig("triggered_watches", "watcher.triggered_watches.index"), new WatcherIndexTemplateRegistry.TemplateConfig("watch_history", "watcher.history.index"), new WatcherIndexTemplateRegistry.TemplateConfig("watches", "watcher.watches.index")};
    protected final Settings settings;

    public WatcherModule(Settings settings) {
        this.settings = settings;
    }

    protected void configure() {
        this.bind(WatcherLifeCycleService.class).asEagerSingleton();
        this.bind(WatcherSettingsValidation.class).asEagerSingleton();
        this.bind(WatcherIndexTemplateRegistry.class).asEagerSingleton();
        Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), WatcherIndexTemplateRegistry.TemplateConfig.class);
        for (WatcherIndexTemplateRegistry.TemplateConfig templateConfig : TEMPLATE_CONFIGS) {
            multibinder.addBinding().toInstance((Object)templateConfig);
        }
    }
}

