/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher;

import java.util.concurrent.CountDownLatch;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.WatcherMetaData;
import org.elasticsearch.watcher.WatcherService;
import org.elasticsearch.watcher.WatcherState;

public class WatcherLifeCycleService
extends AbstractComponent
implements ClusterStateListener {
    private final ThreadPool threadPool;
    private final WatcherService watcherService;
    private final ClusterService clusterService;
    private volatile WatcherMetaData watcherMetaData;

    @Inject
    public WatcherLifeCycleService(Settings settings, ThreadPool threadPool, ClusterService clusterService, WatcherService watcherService) {
        super(settings);
        this.threadPool = threadPool;
        this.watcherService = watcherService;
        this.clusterService = clusterService;
        clusterService.add((ClusterStateListener)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                WatcherLifeCycleService.this.stop(false);
            }
        });
        this.watcherMetaData = new WatcherMetaData(settings.getAsBoolean("watcher.start_immediately", Boolean.valueOf(true)) == false);
    }

    public void start() {
        this.start(this.clusterService.state(), true);
    }

    public void stop() {
        this.stop(true);
    }

    private synchronized void stop(boolean manual) {
        WatcherState watcherState = this.watcherService.state();
        if (watcherState != WatcherState.STARTED) {
            this.logger.debug("not stopping watcher. watcher can only stop if its current state is [{}], but its current state now is [{}]", new Object[]{WatcherState.STARTED, watcherState});
        } else {
            this.watcherService.stop();
        }
        if (manual) {
            this.updateManualStopped(true);
        }
    }

    private synchronized void start(ClusterState state, boolean manual) {
        WatcherState watcherState = this.watcherService.state();
        if (watcherState != WatcherState.STOPPED) {
            this.logger.debug("not starting watcher. watcher can only start if its current state is [{}], but its current state now is [{}]", new Object[]{WatcherState.STOPPED, watcherState});
            return;
        }
        if (!manual && this.watcherMetaData.manuallyStopped()) {
            this.logger.debug("not starting watcher. watcher was stopped manually and therefore cannot be auto-started", new Object[0]);
            return;
        }
        if (this.watcherService.validate(state)) {
            this.logger.trace("starting... (based on cluster state version [{}]) (manual [{}])", new Object[]{state.getVersion(), manual});
            try {
                this.watcherService.start(state);
            }
            catch (Exception e) {
                this.logger.warn("failed to start watcher. please wait for the cluster to become ready or try to start Watcher manually", (Throwable)e, new Object[0]);
            }
        } else {
            this.logger.debug("not starting watcher. because the cluster isn't ready yet to run watcher", new Object[0]);
        }
        if (manual) {
            this.updateManualStopped(false);
        }
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        WatcherMetaData watcherMetaData = (WatcherMetaData)event.state().getMetaData().custom("watcher");
        if (watcherMetaData != null) {
            this.watcherMetaData = watcherMetaData;
        }
        if (!event.localNodeMaster()) {
            if (this.watcherService.state() != WatcherState.STARTED) {
                return;
            }
            this.threadPool.executor("generic").execute(new Runnable(){

                @Override
                public void run() {
                    WatcherLifeCycleService.this.stop(false);
                }
            });
        } else {
            if (this.watcherService.state() != WatcherState.STOPPED) {
                return;
            }
            final ClusterState state = event.state();
            this.threadPool.executor("generic").execute(new Runnable(){

                @Override
                public void run() {
                    WatcherLifeCycleService.this.start(state, false);
                }
            });
        }
    }

    public WatcherMetaData watcherMetaData() {
        return this.watcherMetaData;
    }

    private void updateManualStopped(final boolean stopped) {
        this.watcherMetaData = new WatcherMetaData(stopped);
        final CountDownLatch latch = new CountDownLatch(1);
        ActionListener<Boolean> listener = new ActionListener<Boolean>(){

            public void onResponse(Boolean aBoolean) {
                latch.countDown();
            }

            public void onFailure(Throwable throwable) {
                WatcherLifeCycleService.this.logger.warn("updating manually stopped isn't acked", throwable, new Object[0]);
                latch.countDown();
            }
        };
        AckedRequest request = new AckedRequest(){

            public TimeValue ackTimeout() {
                return TimeValue.timeValueSeconds((long)30L);
            }

            public TimeValue masterNodeTimeout() {
                return TimeValue.timeValueSeconds((long)30L);
            }
        };
        this.clusterService.submitStateUpdateTask("update_watcher_manually_stopped", (ClusterStateUpdateTask)new AckedClusterStateUpdateTask<Boolean>(request, (ActionListener)listener){

            protected Boolean newResponse(boolean result) {
                return result;
            }

            public ClusterState execute(ClusterState clusterState) throws Exception {
                ClusterState.Builder builder = new ClusterState.Builder(clusterState);
                builder.metaData(MetaData.builder((MetaData)clusterState.getMetaData()).putCustom("watcher", (MetaData.Custom)new WatcherMetaData(stopped)));
                return builder.build();
            }

            public void onFailure(String source, Throwable throwable) {
                latch.countDown();
                WatcherLifeCycleService.this.logger.warn("couldn't update watcher metadata [{}]", throwable, new Object[]{source});
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }
}

