/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.watch;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.ActionRegistry;
import org.elasticsearch.watcher.actions.ActionStatus;
import org.elasticsearch.watcher.actions.ActionWrapper;
import org.elasticsearch.watcher.actions.ExecutableActions;
import org.elasticsearch.watcher.condition.ConditionRegistry;
import org.elasticsearch.watcher.condition.ExecutableCondition;
import org.elasticsearch.watcher.condition.always.ExecutableAlwaysCondition;
import org.elasticsearch.watcher.input.ExecutableInput;
import org.elasticsearch.watcher.input.InputRegistry;
import org.elasticsearch.watcher.input.none.ExecutableNoneInput;
import org.elasticsearch.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.watcher.support.clock.Clock;
import org.elasticsearch.watcher.support.clock.HaltedClock;
import org.elasticsearch.watcher.support.secret.SecretService;
import org.elasticsearch.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.watcher.support.xcontent.WatcherXContentParser;
import org.elasticsearch.watcher.transform.ExecutableTransform;
import org.elasticsearch.watcher.transform.TransformRegistry;
import org.elasticsearch.watcher.trigger.Trigger;
import org.elasticsearch.watcher.trigger.TriggerEngine;
import org.elasticsearch.watcher.trigger.TriggerService;
import org.elasticsearch.watcher.watch.WatchStatus;
import org.joda.time.DateTime;
import org.joda.time.PeriodType;

public class Watch
implements TriggerEngine.Job,
ToXContent {
    public static final String ALL_ACTIONS_ID = "_all";
    public static final String INCLUDE_STATUS_KEY = "include_status";
    private final String id;
    private final Trigger trigger;
    private final ExecutableInput input;
    private final ExecutableCondition condition;
    @Nullable
    private final ExecutableTransform transform;
    private final ExecutableActions actions;
    @Nullable
    private final TimeValue throttlePeriod;
    @Nullable
    private final Map<String, Object> metadata;
    private final WatchStatus status;
    private final transient AtomicLong nonceCounter = new AtomicLong();
    private transient long version = -2L;

    public Watch(String id, Trigger trigger, ExecutableInput input, ExecutableCondition condition, @Nullable ExecutableTransform transform, @Nullable TimeValue throttlePeriod, ExecutableActions actions, @Nullable Map<String, Object> metadata, WatchStatus status) {
        this.id = id;
        this.trigger = trigger;
        this.input = input;
        this.condition = condition;
        this.transform = transform;
        this.actions = actions;
        this.throttlePeriod = throttlePeriod;
        this.metadata = metadata;
        this.status = status;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Trigger trigger() {
        return this.trigger;
    }

    public ExecutableInput input() {
        return this.input;
    }

    public ExecutableCondition condition() {
        return this.condition;
    }

    public ExecutableTransform transform() {
        return this.transform;
    }

    public TimeValue throttlePeriod() {
        return this.throttlePeriod;
    }

    public ExecutableActions actions() {
        return this.actions;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public WatchStatus status() {
        return this.status;
    }

    public long version() {
        return this.version;
    }

    public void version(long version) {
        this.version = version;
    }

    public boolean setState(boolean active, DateTime now) {
        return this.status.setActive(active, now);
    }

    public boolean ack(DateTime now, String ... actions) {
        return this.status.onAck(now, actions);
    }

    public boolean acked(String actionId) {
        ActionStatus actionStatus = this.status.actionStatus(actionId);
        return actionStatus.ackStatus().state() == ActionStatus.AckStatus.State.ACKED;
    }

    public long nonce() {
        return this.nonceCounter.getAndIncrement();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Watch watch = (Watch)o;
        return watch.id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.TRIGGER.getPreferredName()).startObject().field(this.trigger.type(), (ToXContent)this.trigger, params).endObject();
        builder.field(Field.INPUT.getPreferredName()).startObject().field(this.input.type(), (ToXContent)this.input, params).endObject();
        builder.field(Field.CONDITION.getPreferredName()).startObject().field(this.condition.type(), (ToXContent)this.condition, params).endObject();
        if (this.transform != null) {
            builder.field(Field.TRANSFORM.getPreferredName()).startObject().field(this.transform.type(), (ToXContent)this.transform, params).endObject();
        }
        if (this.throttlePeriod != null) {
            if (builder.humanReadable()) {
                builder.field(Field.THROTTLE_PERIOD.getPreferredName(), this.throttlePeriod.format(PeriodType.seconds()));
            } else {
                builder.field(Field.THROTTLE_PERIOD.getPreferredName(), (Object)this.throttlePeriod);
            }
        }
        builder.field(Field.ACTIONS.getPreferredName(), (ToXContent)this.actions, params);
        if (this.metadata != null) {
            builder.field(Field.METADATA.getPreferredName(), this.metadata);
        }
        if (params.paramAsBoolean(INCLUDE_STATUS_KEY, false)) {
            builder.field(Field.STATUS.getPreferredName(), (ToXContent)this.status, params);
        }
        builder.endObject();
        return builder;
    }

    public BytesReference getAsBytes() throws IOException {
        return this.toXContent(XContentFactory.jsonBuilder(), (ToXContent.Params)WatcherParams.builder().put(INCLUDE_STATUS_KEY, true).build()).bytes();
    }

    public static interface Field {
        public static final ParseField TRIGGER = new ParseField("trigger", new String[0]);
        public static final ParseField INPUT = new ParseField("input", new String[0]);
        public static final ParseField CONDITION = new ParseField("condition", new String[0]);
        public static final ParseField ACTIONS = new ParseField("actions", new String[0]);
        public static final ParseField TRANSFORM = new ParseField("transform", new String[0]);
        public static final ParseField THROTTLE_PERIOD = new ParseField("throttle_period", new String[0]);
        public static final ParseField METADATA = new ParseField("metadata", new String[0]);
        public static final ParseField STATUS = new ParseField("_status", new String[0]);
    }

    public static class Parser
    extends AbstractComponent {
        private final ConditionRegistry conditionRegistry;
        private final TriggerService triggerService;
        private final TransformRegistry transformRegistry;
        private final ActionRegistry actionRegistry;
        private final InputRegistry inputRegistry;
        private final SecretService secretService;
        private final ExecutableInput defaultInput;
        private final ExecutableCondition defaultCondition;
        private final ExecutableActions defaultActions;
        private final Clock clock;

        @Inject
        public Parser(Settings settings, ConditionRegistry conditionRegistry, TriggerService triggerService, TransformRegistry transformRegistry, ActionRegistry actionRegistry, InputRegistry inputRegistry, SecretService secretService, Clock clock) {
            super(settings);
            this.conditionRegistry = conditionRegistry;
            this.transformRegistry = transformRegistry;
            this.triggerService = triggerService;
            this.actionRegistry = actionRegistry;
            this.inputRegistry = inputRegistry;
            this.secretService = secretService;
            this.defaultInput = new ExecutableNoneInput(this.logger);
            this.defaultCondition = new ExecutableAlwaysCondition(this.logger);
            this.defaultActions = new ExecutableActions(Collections.EMPTY_LIST);
            this.clock = clock;
        }

        public Watch parse(String name, boolean includeStatus, BytesReference source) throws IOException {
            return this.parse(name, includeStatus, false, source, this.clock.nowUTC());
        }

        public Watch parse(String name, boolean includeStatus, BytesReference source, DateTime now) throws IOException {
            return this.parse(name, includeStatus, false, source, now);
        }

        public Watch parseWithSecrets(String id, boolean includeStatus, BytesReference source) throws IOException {
            return this.parse(id, includeStatus, true, source, this.clock.nowUTC());
        }

        public Watch parseWithSecrets(String id, boolean includeStatus, BytesReference source, DateTime now) throws IOException {
            return this.parse(id, includeStatus, true, source, now);
        }

        private Watch parse(String id, boolean includeStatus, boolean withSecrets, BytesReference source, DateTime now) throws IOException {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("parsing watch [{}] ", new Object[]{source.toUtf8()});
            }
            try (WatcherXContentParser parser = null;){
                parser = new WatcherXContentParser(XContentHelper.createParser((BytesReference)source), new HaltedClock(now), withSecrets ? this.secretService : null);
                parser.nextToken();
                Watch watch = this.parse(id, includeStatus, parser);
                return watch;
            }
        }

        public Watch parse(String id, boolean includeStatus, XContentParser parser) throws IOException {
            XContentParser.Token token;
            Trigger trigger = null;
            ExecutableInput input = this.defaultInput;
            ExecutableCondition condition = this.defaultCondition;
            ExecutableActions actions = this.defaultActions;
            ExecutableTransform transform = null;
            TimeValue throttlePeriod = null;
            Map metatdata = null;
            WatchStatus status = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == null) {
                    throw new ElasticsearchParseException("could not parse watch [{}]. null token", new Object[]{id});
                }
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == null || currentFieldName == null) {
                    throw new ElasticsearchParseException("could not parse watch [{}], unexpected token [{}]", new Object[]{id, token});
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.TRIGGER)) {
                    trigger = this.triggerService.parseTrigger(id, parser);
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.INPUT)) {
                    input = this.inputRegistry.parse(id, parser);
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.CONDITION)) {
                    condition = this.conditionRegistry.parseExecutable(id, parser);
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.TRANSFORM)) {
                    transform = this.transformRegistry.parse(id, parser);
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.THROTTLE_PERIOD)) {
                    try {
                        throttlePeriod = WatcherDateTimeUtils.parseTimeValue(parser, Field.THROTTLE_PERIOD.toString());
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse watch [{}]. failed to parse time value for field [{}]", (Throwable)pe, new Object[]{id, currentFieldName});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ACTIONS)) {
                    actions = this.actionRegistry.parseActions(id, parser);
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.METADATA)) {
                    metatdata = parser.map();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.STATUS)) {
                    if (includeStatus) {
                        status = WatchStatus.parse(id, parser);
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch [{}]. unexpected field [{}]", new Object[]{id, currentFieldName});
            }
            if (trigger == null) {
                throw new ElasticsearchParseException("could not parse watch [{}]. missing required field [{}]", new Object[]{id, Field.TRIGGER.getPreferredName()});
            }
            if (status != null) {
                for (ActionWrapper action : actions) {
                    if (status.actionStatus(action.id()) != null) continue;
                    throw new ElasticsearchParseException("could not parse watch [{}]. watch status in invalid state. action [{}] status is missing", new Object[]{id, action.id()});
                }
            } else {
                ImmutableMap.Builder actionsStatuses = ImmutableMap.builder();
                DateTime now = WatcherXContentParser.clock(parser).nowUTC();
                for (ActionWrapper action : actions) {
                    actionsStatuses.put((Object)action.id(), (Object)new ActionStatus(now));
                }
                status = new WatchStatus(WatcherXContentParser.clock(parser).nowUTC(), (ImmutableMap<String, ActionStatus>)actionsStatuses.build());
            }
            return new Watch(id, trigger, input, condition, transform, throttlePeriod, actions, metatdata, status);
        }
    }
}

