/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.watch;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.watcher.support.WatcherUtils;

public interface Payload
extends ToXContent {
    public static final Simple EMPTY = new Simple(Collections.emptyMap());

    public Map<String, Object> data();

    public static class XContent
    extends Simple {
        public XContent(ToXContent response) throws IOException {
            super(WatcherUtils.responseToData(response));
        }
    }

    public static class Simple
    implements Payload {
        private final Map<String, Object> data;

        public Simple() {
            this(new HashMap<String, Object>());
        }

        public Simple(String key, Object value) {
            this(new MapBuilder().put((Object)key, value).map());
        }

        public Simple(Map<String, Object> data) {
            this.data = data;
        }

        @Override
        public Map<String, Object> data() {
            return this.data;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.value(this.data);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Simple simple = (Simple)o;
            return this.data.equals(simple.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public String toString() {
            return "simple[" + Objects.toString(this.data) + "]";
        }
    }
}

