/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.trigger.schedule.engine;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.watcher.support.clock.Clock;
import org.elasticsearch.watcher.trigger.TriggerEngine;
import org.elasticsearch.watcher.trigger.schedule.Schedule;
import org.elasticsearch.watcher.trigger.schedule.ScheduleRegistry;
import org.elasticsearch.watcher.trigger.schedule.ScheduleTrigger;
import org.elasticsearch.watcher.trigger.schedule.ScheduleTriggerEngine;
import org.elasticsearch.watcher.trigger.schedule.ScheduleTriggerEvent;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SchedulerScheduleTriggerEngine
extends ScheduleTriggerEngine {
    private volatile Schedules schedules;
    private ScheduledExecutorService scheduler;

    @Inject
    public SchedulerScheduleTriggerEngine(Settings settings, ScheduleRegistry scheduleRegistry, Clock clock) {
        super(settings, scheduleRegistry, clock);
    }

    @Override
    public void start(Collection<TriggerEngine.Job> jobs) {
        this.logger.debug("starting schedule engine...", new Object[0]);
        this.scheduler = Executors.newScheduledThreadPool(1, EsExecutors.daemonThreadFactory((String)"trigger_engine_scheduler"));
        long starTime = this.clock.millis();
        ArrayList<ActiveSchedule> schedules = new ArrayList<ActiveSchedule>();
        for (TriggerEngine.Job job : jobs) {
            if (!(job.trigger() instanceof ScheduleTrigger)) continue;
            ScheduleTrigger trigger = (ScheduleTrigger)job.trigger();
            schedules.add(new ActiveSchedule(job.id(), trigger.getSchedule(), starTime));
        }
        this.schedules = new Schedules(schedules);
        this.logger.debug("schedule engine started at [{}]", new Object[]{this.clock.nowUTC()});
    }

    @Override
    public void stop() {
        this.logger.debug("stopping schedule engine...", new Object[0]);
        this.scheduler.shutdownNow();
        try {
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.logger.debug("schedule engine stopped", new Object[0]);
    }

    @Override
    public void add(TriggerEngine.Job job) {
        assert (job.trigger() instanceof ScheduleTrigger);
        ScheduleTrigger trigger = (ScheduleTrigger)job.trigger();
        ActiveSchedule schedule = new ActiveSchedule(job.id(), trigger.getSchedule(), this.clock.millis());
        this.schedules = this.schedules.add(schedule);
    }

    @Override
    public boolean remove(String jobId) {
        Schedules newSchedules = this.schedules.remove(jobId);
        if (newSchedules == null) {
            return false;
        }
        this.schedules = newSchedules;
        return true;
    }

    protected void notifyListeners(String name, long triggeredTime, long scheduledTime) {
        this.logger.trace("triggered job [{}] at [{}] (scheduled time was [{}])", new Object[]{name, new DateTime(triggeredTime, DateTimeZone.UTC), new DateTime(scheduledTime, DateTimeZone.UTC)});
        ScheduleTriggerEvent event = new ScheduleTriggerEvent(name, new DateTime(triggeredTime, DateTimeZone.UTC), new DateTime(scheduledTime, DateTimeZone.UTC));
        for (TriggerEngine.Listener listener : this.listeners) {
            listener.triggered(Arrays.asList(event));
        }
    }

    static class Schedules {
        private final ActiveSchedule[] schedules;
        private final ImmutableMap<String, ActiveSchedule> scheduleByName;

        Schedules(Collection<ActiveSchedule> schedules) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            this.schedules = new ActiveSchedule[schedules.size()];
            int i = 0;
            for (ActiveSchedule schedule : schedules) {
                builder.put((Object)schedule.name, (Object)schedule);
                this.schedules[i++] = schedule;
            }
            this.scheduleByName = builder.build();
        }

        public Schedules(ActiveSchedule[] schedules, ImmutableMap<String, ActiveSchedule> scheduleByName) {
            this.schedules = schedules;
            this.scheduleByName = scheduleByName;
        }

        public Schedules add(ActiveSchedule schedule) {
            boolean replacing = this.scheduleByName.containsKey((Object)schedule.name);
            if (!replacing) {
                ActiveSchedule[] newSchedules = new ActiveSchedule[this.schedules.length + 1];
                System.arraycopy(this.schedules, 0, newSchedules, 0, this.schedules.length);
                newSchedules[this.schedules.length] = schedule;
                ImmutableMap newScheduleByName = ImmutableMap.builder().putAll(this.scheduleByName).put((Object)schedule.name, (Object)schedule).build();
                return new Schedules(newSchedules, (ImmutableMap<String, ActiveSchedule>)newScheduleByName);
            }
            ActiveSchedule[] newSchedules = new ActiveSchedule[this.schedules.length];
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < this.schedules.length; ++i) {
                ActiveSchedule sched;
                if (this.schedules[i].name.equals(schedule.name)) {
                    sched = schedule;
                    this.schedules[i].cancel();
                } else {
                    sched = this.schedules[i];
                }
                newSchedules[i] = sched;
                builder.put((Object)sched.name, (Object)sched);
            }
            return new Schedules(newSchedules, (ImmutableMap<String, ActiveSchedule>)builder.build());
        }

        public Schedules remove(String name) {
            if (!this.scheduleByName.containsKey((Object)name)) {
                return null;
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ActiveSchedule[] newSchedules = new ActiveSchedule[this.schedules.length - 1];
            int i = 0;
            for (ActiveSchedule schedule : this.schedules) {
                if (!schedule.name.equals(name)) {
                    newSchedules[i++] = schedule;
                    builder.put((Object)schedule.name, (Object)schedule);
                    continue;
                }
                schedule.cancel();
            }
            return new Schedules(newSchedules, (ImmutableMap<String, ActiveSchedule>)builder.build());
        }
    }

    class ActiveSchedule
    implements Runnable {
        private final String name;
        private final Schedule schedule;
        private final long startTime;
        private volatile ScheduledFuture<?> future;
        private volatile long scheduledTime;

        public ActiveSchedule(String name, Schedule schedule, long startTime) {
            this.name = name;
            this.schedule = schedule;
            this.startTime = startTime;
            this.scheduledTime = schedule.nextScheduledTimeAfter(startTime, startTime);
            if (this.scheduledTime != -1L) {
                long delay = Math.max(0L, this.scheduledTime - SchedulerScheduleTriggerEngine.this.clock.millis());
                this.future = SchedulerScheduleTriggerEngine.this.scheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public void run() {
            long triggeredTime = SchedulerScheduleTriggerEngine.this.clock.millis();
            SchedulerScheduleTriggerEngine.this.notifyListeners(this.name, triggeredTime, this.scheduledTime);
            this.scheduledTime = this.schedule.nextScheduledTimeAfter(this.startTime, triggeredTime);
            if (this.scheduledTime != -1L) {
                long delay = Math.max(0L, this.scheduledTime - triggeredTime);
                this.future = SchedulerScheduleTriggerEngine.this.scheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
            }
        }

        public void cancel() {
            FutureUtils.cancel(this.future);
        }
    }
}

