/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transport.actions.get;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.watcher.support.validation.Validation;

public class GetWatchRequest
extends MasterNodeReadRequest<GetWatchRequest> {
    private String id;
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;

    public GetWatchRequest() {
    }

    public GetWatchRequest(String id) {
        this.id = id;
    }

    GetWatchRequest setId(String id) {
        this.id = id;
        return this;
    }

    public ActionRequestValidationException validate() {
        Validation.Error error;
        ActionRequestValidationException validationException = null;
        if (this.id == null) {
            validationException = ValidateActions.addValidationError((String)"id is missing", validationException);
        }
        if ((error = Validation.watchId(this.id)) != null) {
            validationException = ValidateActions.addValidationError((String)error.message(), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getId() {
        return this.id;
    }

    public GetWatchRequest setVersion(long version) {
        this.version = version;
        return this;
    }

    public long getVersion() {
        return this.version;
    }

    public GetWatchRequest setVersionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.version = in.readLong();
        this.versionType = VersionType.fromValue((byte)in.readByte());
        this.id = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
        out.writeString(this.id);
    }

    public String toString() {
        return "get [" + this.id + "]";
    }
}

