/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transport.actions.execute;

import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.watcher.condition.always.AlwaysCondition;
import org.elasticsearch.watcher.execution.ActionExecutionMode;
import org.elasticsearch.watcher.execution.ExecutionService;
import org.elasticsearch.watcher.execution.ManualExecutionContext;
import org.elasticsearch.watcher.history.WatchRecord;
import org.elasticsearch.watcher.input.simple.SimpleInput;
import org.elasticsearch.watcher.license.WatcherLicensee;
import org.elasticsearch.watcher.support.Exceptions;
import org.elasticsearch.watcher.support.clock.Clock;
import org.elasticsearch.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.watcher.transport.actions.execute.ExecuteWatchRequest;
import org.elasticsearch.watcher.transport.actions.execute.ExecuteWatchResponse;
import org.elasticsearch.watcher.trigger.TriggerEvent;
import org.elasticsearch.watcher.trigger.TriggerService;
import org.elasticsearch.watcher.trigger.manual.ManualTriggerEvent;
import org.elasticsearch.watcher.watch.Payload;
import org.elasticsearch.watcher.watch.Watch;
import org.elasticsearch.watcher.watch.WatchStore;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TransportExecuteWatchAction
extends WatcherTransportAction<ExecuteWatchRequest, ExecuteWatchResponse> {
    private final ExecutionService executionService;
    private final WatchStore watchStore;
    private final Clock clock;
    private final TriggerService triggerService;
    private final Watch.Parser watchParser;

    @Inject
    public TransportExecuteWatchAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ExecutionService executionService, Clock clock, WatcherLicensee watcherLicensee, WatchStore watchStore, TriggerService triggerService, Watch.Parser watchParser) {
        super(settings, "cluster:admin/watcher/watch/execute", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, watcherLicensee, ExecuteWatchRequest.class);
        this.executionService = executionService;
        this.watchStore = watchStore;
        this.clock = clock;
        this.triggerService = triggerService;
        this.watchParser = watchParser;
    }

    protected String executor() {
        return "management";
    }

    protected ExecuteWatchResponse newResponse() {
        return new ExecuteWatchResponse();
    }

    protected void masterOperation(ExecuteWatchRequest request, ClusterState state, ActionListener<ExecuteWatchResponse> listener) throws ElasticsearchException {
        try {
            boolean knownWatch;
            Watch watch;
            if (request.getId() != null) {
                watch = this.watchStore.get(request.getId());
                if (watch == null) {
                    throw new ElasticsearchException("watch [{}] does not exist", new Object[]{request.getId()});
                }
                knownWatch = true;
            } else if (request.getWatchSource() != null) {
                assert (!request.isRecordExecution());
                watch = this.watchParser.parse("_inlined_", false, request.getWatchSource());
                knownWatch = false;
            } else {
                throw Exceptions.illegalArgument("no watch provided", new Object[0]);
            }
            String triggerType = watch.trigger().type();
            TriggerEvent triggerEvent = this.triggerService.simulateEvent(triggerType, watch.id(), request.getTriggerData());
            ManualExecutionContext.Builder ctxBuilder = ManualExecutionContext.builder(watch, knownWatch, new ManualTriggerEvent(triggerEvent.jobName(), triggerEvent), this.executionService.defaultThrottlePeriod());
            DateTime executionTime = this.clock.now(DateTimeZone.UTC);
            ctxBuilder.executionTime(executionTime);
            for (Map.Entry<String, ActionExecutionMode> entry : request.getActionModes().entrySet()) {
                ctxBuilder.actionMode(entry.getKey(), entry.getValue());
            }
            if (request.getAlternativeInput() != null) {
                ctxBuilder.withInput(new SimpleInput.Result(new Payload.Simple(request.getAlternativeInput())));
            }
            if (request.isIgnoreCondition()) {
                ctxBuilder.withCondition(AlwaysCondition.Result.INSTANCE);
            }
            ctxBuilder.recordExecution(request.isRecordExecution());
            WatchRecord record = this.executionService.execute(ctxBuilder.build());
            XContentBuilder builder = XContentFactory.jsonBuilder();
            record.toXContent(builder, (ToXContent.Params)WatcherParams.builder().hideSecrets(true).debug(request.isDebug()).build());
            ExecuteWatchResponse response = new ExecuteWatchResponse(record.id().value(), builder.bytes(), XContentType.JSON);
            listener.onResponse((Object)response);
        }
        catch (Exception e) {
            this.logger.error("failed to execute [{}]", (Throwable)e, new Object[]{request.getId()});
            listener.onFailure((Throwable)e);
        }
    }

    protected ClusterBlockException checkBlock(ExecuteWatchRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, ".watches");
    }
}

