/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transform.search;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.support.SearchRequestEquivalence;
import org.elasticsearch.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.watcher.support.WatcherUtils;
import org.elasticsearch.watcher.transform.Transform;
import org.elasticsearch.watcher.transform.search.ExecutableSearchTransform;
import org.elasticsearch.watcher.watch.Payload;
import org.joda.time.DateTimeZone;

public class SearchTransform
implements Transform {
    public static final String TYPE = "search";
    private final SearchRequest request;
    @Nullable
    private final TimeValue timeout;
    @Nullable
    private final DateTimeZone dynamicNameTimeZone;

    public SearchTransform(SearchRequest request, @Nullable TimeValue timeout, @Nullable DateTimeZone dynamicNameTimeZone) {
        this.request = request;
        this.timeout = timeout;
        this.dynamicNameTimeZone = dynamicNameTimeZone;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public SearchRequest getRequest() {
        return this.request;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public DateTimeZone getDynamicNameTimeZone() {
        return this.dynamicNameTimeZone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchTransform that = (SearchTransform)o;
        if (!SearchRequestEquivalence.INSTANCE.equivalent(this.request, this.request)) {
            return false;
        }
        if (this.timeout != null ? !this.timeout.equals((Object)that.timeout) : that.timeout != null) {
            return false;
        }
        return !(this.dynamicNameTimeZone == null ? that.dynamicNameTimeZone != null : !this.dynamicNameTimeZone.equals((Object)that.dynamicNameTimeZone));
    }

    public int hashCode() {
        int result = this.request.hashCode();
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        result = 31 * result + (this.dynamicNameTimeZone != null ? this.dynamicNameTimeZone.hashCode() : 0);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.REQUEST.getPreferredName());
        builder = WatcherUtils.writeSearchRequest(this.request, builder, params);
        if (this.timeout != null) {
            builder.field(Field.TIMEOUT.getPreferredName(), (Object)this.timeout);
        }
        if (this.dynamicNameTimeZone != null) {
            builder.field(Field.DYNAMIC_NAME_TIMEZONE.getPreferredName(), (Object)this.dynamicNameTimeZone);
        }
        builder.endObject();
        return builder;
    }

    public static SearchTransform parse(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        SearchRequest request = null;
        TimeValue timeout = null;
        DateTimeZone dynamicNameTimeZone = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.REQUEST)) {
                try {
                    request = WatcherUtils.readSearchRequest(parser, ExecutableSearchTransform.DEFAULT_SEARCH_TYPE);
                    continue;
                }
                catch (ElasticsearchParseException srpe) {
                    throw new ElasticsearchParseException("could not parse [{}] transform for watch [{}]. failed to parse [{}]", (Throwable)srpe, new Object[]{TYPE, watchId, currentFieldName});
                }
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.TIMEOUT)) {
                timeout = WatcherDateTimeUtils.parseTimeValue(parser, Field.TIMEOUT.toString());
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.DYNAMIC_NAME_TIMEZONE)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    dynamicNameTimeZone = DateTimeZone.forID((String)parser.text());
                    continue;
                }
                throw new ElasticsearchParseException("could not parse [{}] transform for watch [{}]. failed to parse [{}]. must be a string value (e.g. 'UTC' or '+01:00').", new Object[]{TYPE, watchId, currentFieldName});
            }
            throw new ElasticsearchParseException("could not parse [{}] transform for watch [{}]. unexpected field [{}]", new Object[]{TYPE, watchId, currentFieldName});
        }
        if (request == null) {
            throw new ElasticsearchParseException("could not parse [{}] transform for watch [{}]. missing required [{}] field", new Object[]{TYPE, watchId, Field.REQUEST.getPreferredName()});
        }
        return new SearchTransform(request, timeout, dynamicNameTimeZone);
    }

    public static Builder builder(SearchRequest request) {
        return new Builder(request);
    }

    public static interface Field
    extends Transform.Field {
        public static final ParseField REQUEST = new ParseField("request", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField DYNAMIC_NAME_TIMEZONE = new ParseField("dynamic_name_timezone", new String[0]);
    }

    public static class Builder
    implements Transform.Builder<SearchTransform> {
        private final SearchRequest request;
        private TimeValue timeout;
        private DateTimeZone dynamicNameTimeZone;

        public Builder(SearchRequest request) {
            this.request = request;
        }

        public Builder timeout(TimeValue readTimeout) {
            this.timeout = readTimeout;
            return this;
        }

        public Builder dynamicNameTimeZone(DateTimeZone dynamicNameTimeZone) {
            this.dynamicNameTimeZone = dynamicNameTimeZone;
            return this;
        }

        @Override
        public SearchTransform build() {
            return new SearchTransform(this.request, this.timeout, this.dynamicNameTimeZone);
        }
    }

    public static class Result
    extends Transform.Result {
        @Nullable
        private final SearchRequest request;

        public Result(SearchRequest request, Payload payload) {
            super(SearchTransform.TYPE, payload);
            this.request = request;
        }

        public Result(SearchRequest request, Exception e) {
            super(SearchTransform.TYPE, e);
            this.request = request;
        }

        public SearchRequest executedRequest() {
            return this.request;
        }

        @Override
        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.request != null) {
                builder.startObject(this.type);
                builder.field(Field.REQUEST.getPreferredName());
                WatcherUtils.writeSearchRequest(this.request, builder, params);
                builder.endObject();
            }
            return builder;
        }
    }
}

