/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transform.search;

import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.support.WatcherUtils;
import org.elasticsearch.watcher.support.init.proxy.ClientProxy;
import org.elasticsearch.watcher.transform.ExecutableTransform;
import org.elasticsearch.watcher.transform.search.SearchTransform;
import org.elasticsearch.watcher.watch.Payload;

public class ExecutableSearchTransform
extends ExecutableTransform<SearchTransform, SearchTransform.Result> {
    public static final SearchType DEFAULT_SEARCH_TYPE = SearchType.QUERY_THEN_FETCH;
    protected final ClientProxy client;
    @Nullable
    protected final TimeValue timeout;

    public ExecutableSearchTransform(SearchTransform transform, ESLogger logger, ClientProxy client, @Nullable TimeValue defaultTimeout) {
        super(transform, logger);
        this.client = client;
        this.timeout = transform.getTimeout() != null ? transform.getTimeout() : defaultTimeout;
    }

    @Override
    public SearchTransform.Result execute(WatchExecutionContext ctx, Payload payload) {
        SearchRequest request = null;
        try {
            request = WatcherUtils.createSearchRequestFromPrototype(((SearchTransform)this.transform).getRequest(), ctx, payload);
            SearchResponse resp = this.client.search(request, this.timeout);
            return new SearchTransform.Result(request, (Payload)new Payload.XContent((ToXContent)resp));
        }
        catch (Exception e) {
            this.logger.error("failed to execute [{}] transform for [{}]", (Throwable)e, new Object[]{"search", ctx.id()});
            return new SearchTransform.Result(request, e);
        }
    }
}

