/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transform.chain;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.support.init.InitializingService;
import org.elasticsearch.watcher.transform.ExecutableTransform;
import org.elasticsearch.watcher.transform.Transform;
import org.elasticsearch.watcher.transform.TransformFactory;
import org.elasticsearch.watcher.transform.TransformRegistry;
import org.elasticsearch.watcher.transform.chain.ChainTransform;
import org.elasticsearch.watcher.transform.chain.ExecutableChainTransform;

public class ChainTransformFactory
extends TransformFactory<ChainTransform, ChainTransform.Result, ExecutableChainTransform>
implements InitializingService.Initializable {
    private TransformRegistry registry;

    public ChainTransformFactory(Settings settings) {
        super(Loggers.getLogger(ExecutableChainTransform.class, (Settings)settings, (String[])new String[0]));
    }

    public ChainTransformFactory(TransformRegistry registry) {
        super(Loggers.getLogger(ExecutableChainTransform.class));
        this.registry = registry;
    }

    public ChainTransformFactory() {
        super(Loggers.getLogger(ExecutableChainTransform.class));
    }

    @Override
    public void init(Injector injector) {
        this.init((TransformRegistry)injector.getInstance(TransformRegistry.class));
    }

    public void init(TransformRegistry registry) {
        this.registry = registry;
    }

    @Override
    public String type() {
        return "chain";
    }

    @Override
    public ChainTransform parseTransform(String watchId, XContentParser parser) throws IOException {
        return ChainTransform.parse(watchId, parser, this.registry);
    }

    @Override
    public ExecutableChainTransform createExecutable(ChainTransform chainTransform) {
        ArrayList<ExecutableTransform> executables = new ArrayList<ExecutableTransform>();
        for (Transform transform : chainTransform.getTransforms()) {
            TransformFactory factory = this.registry.factory(transform.type());
            executables.add((ExecutableTransform)factory.createExecutable(transform));
        }
        return new ExecutableChainTransform(chainTransform, this.transformLogger, executables);
    }
}

