/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transform;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.watcher.transform.TransformFactory;
import org.elasticsearch.watcher.transform.chain.ChainTransformFactory;
import org.elasticsearch.watcher.transform.script.ScriptTransformFactory;
import org.elasticsearch.watcher.transform.search.SearchTransformFactory;

public class TransformModule
extends AbstractModule {
    private Map<String, Class<? extends TransformFactory>> factories = new HashMap<String, Class<? extends TransformFactory>>();

    public void registerTransform(String payloadType, Class<? extends TransformFactory> parserType) {
        this.factories.put(payloadType, parserType);
    }

    protected void configure() {
        MapBinder mbinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, TransformFactory.class);
        this.bind(SearchTransformFactory.class).asEagerSingleton();
        mbinder.addBinding((Object)"search").to(SearchTransformFactory.class);
        this.bind(ScriptTransformFactory.class).asEagerSingleton();
        mbinder.addBinding((Object)"script").to(ScriptTransformFactory.class);
        this.bind(ChainTransformFactory.class).asEagerSingleton();
        mbinder.addBinding((Object)"chain").to(ChainTransformFactory.class);
        for (Map.Entry<String, Class<? extends TransformFactory>> entry : this.factories.entrySet()) {
            this.bind(entry.getValue()).asEagerSingleton();
            mbinder.addBinding((Object)entry.getKey()).to(entry.getValue());
        }
    }
}

