/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transform;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.watcher.watch.Payload;

public interface Transform
extends ToXContent {
    public String type();

    public static interface Field {
        public static final ParseField TRANSFORM = new ParseField("transform", new String[0]);
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField STATUS = new ParseField("status", new String[0]);
        public static final ParseField PAYLOAD = new ParseField("payload", new String[0]);
        public static final ParseField REASON = new ParseField("reason", new String[0]);
    }

    public static interface Builder<T extends Transform> {
        public T build();
    }

    public static abstract class Result
    implements ToXContent {
        protected final String type;
        protected final Status status;
        @Nullable
        protected final Payload payload;
        @Nullable
        protected final String reason;

        public Result(String type, Payload payload) {
            this.type = type;
            this.status = Status.SUCCESS;
            this.payload = payload;
            this.reason = null;
        }

        public Result(String type, Exception e) {
            this(type, ExceptionsHelper.detailedMessage((Throwable)e));
        }

        public Result(String type, String errorMessage) {
            this.type = type;
            this.status = Status.FAILURE;
            this.reason = errorMessage;
            this.payload = null;
        }

        public String type() {
            return this.type;
        }

        public Status status() {
            return this.status;
        }

        public Payload payload() {
            assert (this.status == Status.SUCCESS);
            return this.payload;
        }

        public String reason() {
            assert (this.status == Status.FAILURE);
            return this.reason;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Field.TYPE.getPreferredName(), this.type);
            builder.field(Field.STATUS.getPreferredName(), this.status.name().toLowerCase(Locale.ROOT));
            switch (this.status) {
                case SUCCESS: {
                    assert (this.reason == null);
                    builder.field(Field.PAYLOAD.getPreferredName(), (ToXContent)this.payload, params);
                    break;
                }
                case FAILURE: {
                    assert (this.payload == null);
                    builder.field(Field.REASON.getPreferredName(), this.reason);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.typeXContent(builder, params);
            return builder.endObject();
        }

        protected abstract XContentBuilder typeXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

        public static enum Status {
            SUCCESS,
            FAILURE;

        }
    }
}

