/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.text.xmustache;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.Template;
import org.elasticsearch.watcher.support.init.proxy.ScriptServiceProxy;
import org.elasticsearch.watcher.support.text.TextTemplate;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;

public class XMustacheTextTemplateEngine
extends AbstractComponent
implements TextTemplateEngine {
    private final ScriptServiceProxy service;

    @Inject
    public XMustacheTextTemplateEngine(Settings settings, ScriptServiceProxy service) {
        super(settings);
        this.service = service;
    }

    @Override
    public String render(TextTemplate template, Map<String, Object> model) {
        HashMap<String, Object> mergedModel = new HashMap<String, Object>();
        mergedModel.putAll(template.getParams());
        mergedModel.putAll(model);
        ExecutableScript executable = this.service.executable((Script)new Template(template.getTemplate(), template.getType(), "xmustache", template.getContentType(), mergedModel));
        Object result = executable.run();
        if (result instanceof BytesReference) {
            return ((BytesReference)result).toUtf8();
        }
        return result.toString();
    }
}

