/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.text.xmustache;

import com.github.mustachejava.Mustache;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.io.UTF8StreamWriter;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.watcher.support.text.xmustache.XMustacheFactory;

public class XMustacheScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    public static final String NAME = "xmustache";
    private static ThreadLocal<SoftReference<UTF8StreamWriter>> utf8StreamWriter = new ThreadLocal();

    @Inject
    public XMustacheScriptEngineService(Settings settings) {
        super(settings);
    }

    public Object compile(String template) {
        XContentType xContentType = this.detectContentType(template);
        template = this.trimContentType(template);
        return new XMustacheFactory(xContentType).compile((Reader)new FastStringReader(template), "query-template");
    }

    public String[] types() {
        return new String[]{NAME};
    }

    public String[] extensions() {
        return new String[]{NAME};
    }

    public boolean sandboxed() {
        return true;
    }

    public ExecutableScript executable(CompiledScript compiledScript, @Nullable Map<String, Object> vars) {
        return new MustacheExecutableScript((Mustache)compiledScript.compiled(), vars);
    }

    public SearchScript search(CompiledScript compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public void scriptRemoved(CompiledScript script) {
    }

    public static String prepareTemplate(String template, @Nullable XContentType contentType) {
        if (contentType == null) {
            return template;
        }
        return "__" + contentType.shortName().toLowerCase(Locale.ROOT) + "__::" + template;
    }

    private static UTF8StreamWriter utf8StreamWriter() {
        UTF8StreamWriter writer;
        SoftReference<UTF8StreamWriter> ref = utf8StreamWriter.get();
        UTF8StreamWriter uTF8StreamWriter = writer = ref == null ? null : ref.get();
        if (writer == null) {
            writer = new UTF8StreamWriter(4096);
            utf8StreamWriter.set(new SoftReference<UTF8StreamWriter>(writer));
        }
        writer.reset();
        return writer;
    }

    private String trimContentType(String template) {
        if (!template.startsWith("__")) {
            return template;
        }
        int index = template.indexOf("__::", 3);
        if (index >= 0 && index < 12) {
            template = template.length() == 6 ? "" : template.substring(index + 4);
        }
        return template;
    }

    private XContentType detectContentType(String template) {
        int endOfContentName;
        if (template.startsWith("__") && (endOfContentName = template.indexOf("__::", 3)) != -1) {
            return XContentType.fromRestContentType((String)template.substring(2, endOfContentName));
        }
        return null;
    }

    private class MustacheExecutableScript
    implements ExecutableScript {
        private Mustache mustache;
        private Map<String, Object> vars;

        public MustacheExecutableScript(Mustache mustache, Map<String, Object> vars) {
            this.mustache = mustache;
            this.vars = vars == null ? Collections.emptyMap() : vars;
        }

        public void setNextVar(String name, Object value) {
            this.vars.put(name, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() {
            BytesStreamOutput result = new BytesStreamOutput();
            UTF8StreamWriter writer = XMustacheScriptEngineService.utf8StreamWriter().setOutput((OutputStream)result);
            this.mustache.execute((Writer)writer, this.vars);
            try {
                writer.flush();
            }
            catch (IOException e) {
                XMustacheScriptEngineService.this.logger.error("Could not execute query template (failed to flush writer): ", (Throwable)e, new Object[0]);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    XMustacheScriptEngineService.this.logger.error("Could not execute query template (failed to close writer): ", (Throwable)e, new Object[0]);
                }
            }
            return result.bytes();
        }

        public Object unwrap(Object value) {
            return value;
        }
    }
}

