/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.secret;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.watcher.support.secret.SecretService;

public class Secret
implements ToXContent {
    protected final char[] text;

    public Secret(char[] text) {
        this.text = text;
    }

    public char[] text(SecretService service) {
        return service.decrypt(this.text);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(new String(this.text));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Secret secret = (Secret)o;
        return Arrays.equals(this.text, secret.text);
    }

    public int hashCode() {
        return Arrays.hashCode(this.text);
    }
}

