/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.http.auth.basic;

import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import org.elasticsearch.common.Base64;
import org.elasticsearch.watcher.support.http.auth.ApplicableHttpAuth;
import org.elasticsearch.watcher.support.http.auth.basic.BasicAuth;
import org.elasticsearch.watcher.support.secret.SecretService;

public class ApplicableBasicAuth
extends ApplicableHttpAuth<BasicAuth> {
    private final String basicAuth;

    public ApplicableBasicAuth(BasicAuth auth, SecretService service) {
        super(auth);
        this.basicAuth = ApplicableBasicAuth.headerValue(auth.username, auth.password.text(service));
    }

    public static String headerValue(String username, char[] password) {
        return "Basic " + Base64.encodeBytes((byte[])(username + ":" + new String(password)).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void apply(HttpURLConnection connection) {
        connection.setRequestProperty("Authorization", this.basicAuth);
    }
}

