/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.http;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class HttpResponse
implements ToXContent {
    private final int status;
    private final ImmutableMap<String, String[]> headers;
    private final BytesReference body;

    public HttpResponse(int status) {
        this(status, (ImmutableMap<String, String[]>)ImmutableMap.of());
    }

    public HttpResponse(int status, ImmutableMap<String, String[]> headers) {
        this(status, (BytesReference)null, headers);
    }

    public HttpResponse(int status, @Nullable String body) {
        this(status, (BytesReference)(body != null ? new BytesArray(body) : null), (ImmutableMap<String, String[]>)ImmutableMap.of());
    }

    public HttpResponse(int status, @Nullable String body, ImmutableMap<String, String[]> headers) {
        this(status, (BytesReference)(body != null ? new BytesArray(body) : null), headers);
    }

    public HttpResponse(int status, @Nullable byte[] body) {
        this(status, (BytesReference)(body != null ? new BytesArray(body) : null), (ImmutableMap<String, String[]>)ImmutableMap.of());
    }

    public HttpResponse(int status, @Nullable byte[] body, ImmutableMap<String, String[]> headers) {
        this(status, (BytesReference)(body != null ? new BytesArray(body) : null), headers);
    }

    public HttpResponse(int status, @Nullable BytesReference body, ImmutableMap<String, String[]> headers) {
        this.status = status;
        this.body = body;
        MapBuilder mapBuilder = MapBuilder.newMapBuilder();
        for (Map.Entry entry : headers.entrySet()) {
            mapBuilder.put((Object)((String)entry.getKey()).toLowerCase(Locale.ROOT), entry.getValue());
        }
        this.headers = mapBuilder.immutableMap();
    }

    public int status() {
        return this.status;
    }

    public boolean hasContent() {
        return this.body != null;
    }

    public BytesReference body() {
        return this.body;
    }

    public String[] header(String header) {
        return (String[])this.headers.get((Object)header.toLowerCase(Locale.ROOT));
    }

    public String contentType() {
        String[] values = this.header("Content-Type");
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public XContentType xContentType() {
        String[] values = this.header("Content-Type");
        if (values == null || values.length == 0) {
            return null;
        }
        return XContentType.fromRestContentType((String)values[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpResponse that = (HttpResponse)o;
        if (this.status != that.status) {
            return false;
        }
        if (!this.headers.equals(that.headers)) {
            return false;
        }
        return !(this.body == null ? that.body != null : !this.body.equals(that.body));
    }

    public int hashCode() {
        int result = this.status;
        result = 31 * result + this.headers.hashCode();
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("status=[").append(this.status).append("]");
        if (!this.headers.isEmpty()) {
            sb.append(", headers=[");
            boolean first = true;
            for (Map.Entry header : this.headers.entrySet()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append("[").append((String)header.getKey()).append(": ").append(Arrays.toString((Object[])header.getValue())).append("]");
                first = false;
            }
            sb.append("]");
        }
        if (this.hasContent()) {
            sb.append(", body=[").append(this.body.toUtf8()).append("]");
        }
        return sb.toString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder = builder.startObject().field(Field.STATUS.getPreferredName(), this.status);
        if (!this.headers.isEmpty()) {
            builder.startObject(Field.HEADERS.getPreferredName());
            for (Map.Entry header : this.headers.entrySet()) {
                builder.array((String)header.getKey(), (String[])header.getValue());
            }
            builder.endObject();
        }
        if (this.hasContent()) {
            builder = builder.field(Field.BODY.getPreferredName(), this.body.toUtf8());
        }
        builder.endObject();
        return builder;
    }

    public static HttpResponse parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT);
        int status = -1;
        String body = null;
        ImmutableMap.Builder headers = ImmutableMap.builder();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (currentFieldName == null) {
                throw new ElasticsearchParseException("could not parse http response. expected a field name but found [{}] instead", new Object[]{token});
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.STATUS)) {
                    status = parser.intValue();
                    continue;
                }
                throw new ElasticsearchParseException("could not parse http response. unknown numeric field [{}]", new Object[]{currentFieldName});
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.BODY)) {
                    body = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("could not parse http response. unknown string field [{}]", new Object[]{currentFieldName});
            }
            if (token == XContentParser.Token.START_OBJECT) {
                String headerName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        headerName = parser.currentName();
                        continue;
                    }
                    if (headerName == null) {
                        throw new ElasticsearchParseException("could not parse http response. expected a header name but found [{}] instead", new Object[]{token});
                    }
                    if (token.isValue()) {
                        headers.put((Object)headerName, (Object)new String[]{String.valueOf(parser.objectText())});
                        continue;
                    }
                    if (token != XContentParser.Token.START_ARRAY) continue;
                    ArrayList<String> values = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (!token.isValue()) {
                            throw new ElasticsearchParseException("could not parse http response. expected a header value for header [{}] but found [{}] instead", new Object[]{headerName, token});
                        }
                        values.add(String.valueOf(parser.objectText()));
                    }
                    headers.put((Object)headerName, (Object)values.toArray(new String[values.size()]));
                }
                continue;
            }
            throw new ElasticsearchParseException("could not parse http response. unexpected token [{}]", new Object[]{token});
        }
        if (status < 0) {
            throw new ElasticsearchParseException("could not parse http response. missing required numeric [{}] field holding the response's http status code", new Object[]{Field.STATUS.getPreferredName()});
        }
        return new HttpResponse(status, body, (ImmutableMap<String, String[]>)headers.build());
    }

    static interface Field {
        public static final ParseField STATUS = new ParseField("status", new String[0]);
        public static final ParseField HEADERS = new ParseField("headers", new String[0]);
        public static final ParseField BODY = new ParseField("body", new String[0]);
    }
}

