/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.http;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.watcher.support.http.HttpMethod;
import org.elasticsearch.watcher.support.http.HttpProxy;
import org.elasticsearch.watcher.support.http.HttpRequest;
import org.elasticsearch.watcher.support.http.Scheme;
import org.elasticsearch.watcher.support.http.auth.HttpAuth;
import org.elasticsearch.watcher.support.http.auth.HttpAuthRegistry;
import org.elasticsearch.watcher.support.text.TextTemplate;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;

public class HttpRequestTemplate
implements ToXContent {
    private final Scheme scheme;
    private final String host;
    private final int port;
    private final HttpMethod method;
    private final TextTemplate path;
    private final ImmutableMap<String, TextTemplate> params;
    private final ImmutableMap<String, TextTemplate> headers;
    private final HttpAuth auth;
    private final TextTemplate body;
    @Nullable
    private final TimeValue connectionTimeout;
    @Nullable
    private final TimeValue readTimeout;
    @Nullable
    private final HttpProxy proxy;

    public HttpRequestTemplate(String host, int port, @Nullable Scheme scheme, @Nullable HttpMethod method, @Nullable TextTemplate path, Map<String, TextTemplate> params, Map<String, TextTemplate> headers, HttpAuth auth, TextTemplate body, @Nullable TimeValue connectionTimeout, @Nullable TimeValue readTimeout, @Nullable HttpProxy proxy) {
        this.host = host;
        this.port = port;
        this.scheme = scheme != null ? scheme : Scheme.HTTP;
        this.method = method != null ? method : HttpMethod.GET;
        this.path = path;
        this.params = params != null ? ImmutableMap.copyOf(params) : ImmutableMap.of();
        this.headers = headers != null ? ImmutableMap.copyOf(headers) : ImmutableMap.of();
        this.auth = auth;
        this.body = body;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.proxy = proxy;
    }

    public Scheme scheme() {
        return this.scheme;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public HttpMethod method() {
        return this.method;
    }

    public TextTemplate path() {
        return this.path;
    }

    public Map<String, TextTemplate> params() {
        return this.params;
    }

    public Map<String, TextTemplate> headers() {
        return this.headers;
    }

    public HttpAuth auth() {
        return this.auth;
    }

    public TextTemplate body() {
        return this.body;
    }

    public TimeValue connectionTimeout() {
        return this.connectionTimeout;
    }

    public TimeValue readTimeout() {
        return this.readTimeout;
    }

    public HttpProxy proxy() {
        return this.proxy;
    }

    public HttpRequest render(TextTemplateEngine engine, Map<String, Object> model) {
        MapBuilder mapBuilder;
        HttpRequest.Builder request = HttpRequest.builder(this.host, this.port);
        request.method(this.method);
        request.scheme(this.scheme);
        if (this.path != null) {
            request.path(engine.render(this.path, model));
        }
        if (this.params != null && !this.params.isEmpty()) {
            mapBuilder = MapBuilder.newMapBuilder();
            for (Map.Entry entry : this.params.entrySet()) {
                mapBuilder.put(entry.getKey(), (Object)engine.render((TextTemplate)entry.getValue(), model));
            }
            request.setParams(mapBuilder.map());
        }
        if ((this.headers == null || this.headers.isEmpty()) && this.body != null && this.body.getContentType() != null) {
            request.setHeaders((Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)this.body.getContentType().restContentType()));
        } else if (this.headers != null && !this.headers.isEmpty()) {
            mapBuilder = MapBuilder.newMapBuilder();
            if (this.body != null && this.body.getContentType() != null) {
                mapBuilder.put((Object)"Content-Type", (Object)this.body.getContentType().restContentType());
            }
            for (Map.Entry entry : this.headers.entrySet()) {
                mapBuilder.put(entry.getKey(), (Object)engine.render((TextTemplate)entry.getValue(), model));
            }
            request.setHeaders(mapBuilder.map());
        }
        if (this.auth != null) {
            request.auth(this.auth);
        }
        if (this.body != null) {
            request.body(engine.render(this.body, model));
        }
        if (this.connectionTimeout != null) {
            request.connectionTimeout(this.connectionTimeout);
        }
        if (this.readTimeout != null) {
            request.readTimeout(this.readTimeout);
        }
        if (this.proxy != null) {
            request.proxy(this.proxy);
        }
        return request.build();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(HttpRequest.Field.SCHEME.getPreferredName(), (ToXContent)this.scheme, params);
        builder.field(HttpRequest.Field.HOST.getPreferredName(), this.host);
        builder.field(HttpRequest.Field.PORT.getPreferredName(), this.port);
        builder.field(HttpRequest.Field.METHOD.getPreferredName(), (ToXContent)this.method, params);
        if (this.path != null) {
            builder.field(HttpRequest.Field.PATH.getPreferredName(), (ToXContent)this.path, params);
        }
        if (this.params != null) {
            builder.startObject(HttpRequest.Field.PARAMS.getPreferredName());
            for (Map.Entry entry : this.params.entrySet()) {
                builder.field((String)entry.getKey(), (ToXContent)entry.getValue(), params);
            }
            builder.endObject();
        }
        if (this.headers != null) {
            builder.startObject(HttpRequest.Field.HEADERS.getPreferredName());
            for (Map.Entry entry : this.headers.entrySet()) {
                builder.field((String)entry.getKey(), (ToXContent)entry.getValue(), params);
            }
            builder.endObject();
        }
        if (this.auth != null) {
            builder.startObject(HttpRequest.Field.AUTH.getPreferredName()).field(this.auth.type(), (ToXContent)this.auth, params).endObject();
        }
        if (this.body != null) {
            builder.field(HttpRequest.Field.BODY.getPreferredName(), (ToXContent)this.body, params);
        }
        if (this.connectionTimeout != null) {
            builder.field(HttpRequest.Field.CONNECTION_TIMEOUT.getPreferredName(), (Object)this.connectionTimeout);
        }
        if (this.readTimeout != null) {
            builder.field(HttpRequest.Field.READ_TIMEOUT.getPreferredName(), (Object)this.readTimeout);
        }
        if (this.proxy != null) {
            this.proxy.toXContent(builder, params);
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequestTemplate that = (HttpRequestTemplate)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.scheme != that.scheme) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.method != that.method) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(that.params) : that.params != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) {
            return false;
        }
        if (this.connectionTimeout != null ? !this.connectionTimeout.equals((Object)that.connectionTimeout) : that.connectionTimeout != null) {
            return false;
        }
        if (this.readTimeout != null ? !this.readTimeout.equals((Object)that.readTimeout) : that.readTimeout != null) {
            return false;
        }
        if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) {
            return false;
        }
        return this.body != null ? this.body.equals(that.body) : that.body == null;
    }

    public int hashCode() {
        int result = this.scheme != null ? this.scheme.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.connectionTimeout != null ? this.connectionTimeout.hashCode() : 0);
        result = 31 * result + (this.readTimeout != null ? this.readTimeout.hashCode() : 0);
        result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
        return result;
    }

    public static Builder builder(String host, int port) {
        return new Builder(host, port);
    }

    public static class Builder {
        private String host;
        private int port;
        private Scheme scheme;
        private HttpMethod method;
        private TextTemplate path;
        private final ImmutableMap.Builder<String, TextTemplate> params = ImmutableMap.builder();
        private final ImmutableMap.Builder<String, TextTemplate> headers = ImmutableMap.builder();
        private HttpAuth auth;
        private TextTemplate body;
        private TimeValue connectionTimeout;
        private TimeValue readTimeout;
        private HttpProxy proxy;

        private Builder() {
        }

        private Builder(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public Builder scheme(Scheme scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder path(String path) {
            return this.path(TextTemplate.inline(path));
        }

        public Builder path(TextTemplate.Builder path) {
            return this.path(path.build());
        }

        public Builder path(TextTemplate path) {
            this.path = path;
            return this;
        }

        public Builder putParams(Map<String, TextTemplate> params) {
            this.params.putAll(params);
            return this;
        }

        public Builder putParam(String key, TextTemplate.Builder value) {
            return this.putParam(key, value.build());
        }

        public Builder putParam(String key, TextTemplate value) {
            this.params.put((Object)key, (Object)value);
            return this;
        }

        public Builder putHeaders(Map<String, TextTemplate> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder putHeader(String key, TextTemplate.Builder value) {
            return this.putHeader(key, value.build());
        }

        public Builder putHeader(String key, TextTemplate value) {
            this.headers.put((Object)key, (Object)value);
            return this;
        }

        public Builder auth(HttpAuth auth) {
            this.auth = auth;
            return this;
        }

        public Builder body(String body) {
            return this.body(TextTemplate.inline(body));
        }

        public Builder body(TextTemplate.Builder body) {
            return this.body(body.build());
        }

        public Builder body(TextTemplate body) {
            this.body = body;
            return this;
        }

        public Builder body(XContentBuilder content) {
            return this.body(TextTemplate.inline(content));
        }

        public Builder connectionTimeout(TimeValue timeout) {
            this.connectionTimeout = timeout;
            return this;
        }

        public Builder readTimeout(TimeValue timeout) {
            this.readTimeout = timeout;
            return this;
        }

        public Builder proxy(HttpProxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public HttpRequestTemplate build() {
            return new HttpRequestTemplate(this.host, this.port, this.scheme, this.method, this.path, (Map<String, TextTemplate>)this.params.build(), (Map<String, TextTemplate>)this.headers.build(), this.auth, this.body, this.connectionTimeout, this.readTimeout, this.proxy);
        }
    }

    public static class Parser {
        private final HttpAuthRegistry httpAuthRegistry;

        @Inject
        public Parser(HttpAuthRegistry httpAuthRegistry) {
            this.httpAuthRegistry = httpAuthRegistry;
        }

        public HttpRequestTemplate parse(XContentParser parser) throws IOException {
            XContentParser.Token token;
            assert (parser.currentToken() == XContentParser.Token.START_OBJECT);
            Builder builder = new Builder();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, HttpRequest.Field.PROXY)) {
                    builder.proxy(HttpProxy.parse(parser));
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, HttpRequest.Field.PATH)) {
                    builder.path(Parser.parseFieldTemplate(currentFieldName, parser));
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, HttpRequest.Field.HEADERS)) {
                    builder.putHeaders(Parser.parseFieldTemplates(currentFieldName, parser));
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, HttpRequest.Field.PARAMS)) {
                    builder.putParams(Parser.parseFieldTemplates(currentFieldName, parser));
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, HttpRequest.Field.BODY)) {
                    builder.body(Parser.parseFieldTemplate(currentFieldName, parser));
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, HttpRequest.Field.CONNECTION_TIMEOUT)) {
                    try {
                        builder.connectionTimeout(WatcherDateTimeUtils.parseTimeValue(parser, HttpRequest.Field.CONNECTION_TIMEOUT.toString()));
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse http request template. invalid time value for [{}] field", (Throwable)pe, new Object[]{currentFieldName});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, HttpRequest.Field.READ_TIMEOUT)) {
                    try {
                        builder.readTimeout(WatcherDateTimeUtils.parseTimeValue(parser, HttpRequest.Field.READ_TIMEOUT.toString()));
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse http request template. invalid time value for [{}] field", (Throwable)pe, new Object[]{currentFieldName});
                    }
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (ParseFieldMatcher.STRICT.match(currentFieldName, HttpRequest.Field.AUTH)) {
                        builder.auth(this.httpAuthRegistry.parse(parser));
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse http request template. unexpected object field [{}]", new Object[]{currentFieldName});
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if (ParseFieldMatcher.STRICT.match(currentFieldName, HttpRequest.Field.SCHEME)) {
                        builder.scheme(Scheme.parse(parser.text()));
                        continue;
                    }
                    if (ParseFieldMatcher.STRICT.match(currentFieldName, HttpRequest.Field.METHOD)) {
                        builder.method(HttpMethod.parse(parser.text()));
                        continue;
                    }
                    if (ParseFieldMatcher.STRICT.match(currentFieldName, HttpRequest.Field.HOST)) {
                        builder.host = parser.text();
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse http request template. unexpected string field [{}]", new Object[]{currentFieldName});
                }
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    if (ParseFieldMatcher.STRICT.match(currentFieldName, HttpRequest.Field.PORT)) {
                        builder.port = parser.intValue();
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse http request template. unexpected numeric field [{}]", new Object[]{currentFieldName});
                }
                throw new ElasticsearchParseException("could not parse http request template. unexpected token [{}] for field [{}]", new Object[]{token, currentFieldName});
            }
            if (builder.host == null) {
                throw new ElasticsearchParseException("could not parse http request template. missing required [{}] string field", new Object[]{HttpRequest.Field.HOST.getPreferredName()});
            }
            if (builder.port <= 0) {
                throw new ElasticsearchParseException("could not parse http request template. wrong port for [{}]", new Object[]{HttpRequest.Field.PORT.getPreferredName()});
            }
            return builder.build();
        }

        private static TextTemplate parseFieldTemplate(String field, XContentParser parser) throws IOException {
            try {
                return TextTemplate.parse(parser);
            }
            catch (ElasticsearchParseException pe) {
                throw new ElasticsearchParseException("could not parse http request template. could not parse value for [{}] field", (Throwable)pe, new Object[]{field});
            }
        }

        private static Map<String, TextTemplate> parseFieldTemplates(String field, XContentParser parser) throws IOException {
            XContentParser.Token token;
            HashMap<String, TextTemplate> templates = new HashMap<String, TextTemplate>();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                templates.put(currentFieldName, Parser.parseFieldTemplate(field, parser));
            }
            return templates;
        }
    }
}

