/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.http;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.watcher.support.Exceptions;

public enum HttpContentType implements ToXContent
{
    JSON{

        @Override
        public XContentType contentType() {
            return XContentType.JSON;
        }
    }
    ,
    YAML{

        @Override
        public XContentType contentType() {
            return XContentType.YAML;
        }
    }
    ,
    TEXT{

        @Override
        public XContentType contentType() {
            return null;
        }
    };


    public abstract XContentType contentType();

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.id());
    }

    public String toString() {
        return this.id();
    }

    public String id() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static HttpContentType resolve(String id) {
        switch (id.toLowerCase(Locale.ROOT)) {
            case "json": {
                return JSON;
            }
            case "yaml": {
                return YAML;
            }
            case "text": {
                return TEXT;
            }
        }
        throw Exceptions.illegalArgument("unknown http content type [{}]", id);
    }
}

