/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.support.init.proxy.ClientProxy;
import org.elasticsearch.watcher.watch.WatchStore;

public class WatcherIndexTemplateRegistry
extends AbstractComponent
implements ClusterStateListener,
NodeSettingsService.Listener {
    private static final ImmutableSet<String> forbiddenIndexSettings = ImmutableSet.of((Object)"index.mapper.dynamic");
    private final ClientProxy client;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final ImmutableSet<TemplateConfig> indexTemplates;
    private volatile ImmutableMap<String, Settings> customIndexSettings;

    @Inject
    public WatcherIndexTemplateRegistry(Settings settings, NodeSettingsService nodeSettingsService, ClusterService clusterService, ThreadPool threadPool, ClientProxy client, Set<TemplateConfig> configs) {
        super(settings);
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indexTemplates = ImmutableSet.copyOf(configs);
        clusterService.add((ClusterStateListener)this);
        nodeSettingsService.addListener((NodeSettingsService.Listener)this);
        ImmutableMap.Builder customIndexSettingsBuilder = ImmutableMap.builder();
        for (TemplateConfig indexTemplate : this.indexTemplates) {
            Settings customSettings = this.settings.getAsSettings(indexTemplate.getSettingsPrefix());
            this.customIndexSettings = customIndexSettingsBuilder.put((Object)indexTemplate.getSettingsPrefix(), (Object)customSettings).build();
        }
        this.customIndexSettings = customIndexSettingsBuilder.build();
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (!event.localNodeMaster()) {
            return;
        }
        this.addTemplatesIfMissing(state, false);
    }

    public void addTemplatesIfMissing() {
        this.addTemplatesIfMissing(this.clusterService.state(), true);
    }

    void addTemplatesIfMissing(ClusterState state, boolean wait) {
        for (TemplateConfig template : this.indexTemplates) {
            if (!state.metaData().getTemplates().containsKey((Object)template.getTemplateName())) {
                this.logger.debug("adding index template [{}], because it doesn't exist", new Object[]{template.getTemplateName()});
                this.putTemplate(template, wait);
                continue;
            }
            this.logger.trace("not adding index template [{}], because it already exists", new Object[]{template.getTemplateName()});
        }
    }

    public void onRefreshSettings(Settings settings) {
        if (!this.clusterService.localNode().masterNode()) {
            return;
        }
        for (TemplateConfig config : this.indexTemplates) {
            Settings newSettings = Settings.builder().put(settings.getAsSettings(config.getSettingsPrefix())).build();
            if (newSettings.names().isEmpty()) continue;
            Settings existingSettings = (Settings)this.customIndexSettings.get((Object)config.getSettingsPrefix());
            if (existingSettings == null) {
                existingSettings = Settings.EMPTY;
            }
            boolean changed = false;
            Settings.Builder builder = Settings.builder().put(existingSettings);
            for (Map.Entry newSettingsEntry : newSettings.getAsMap().entrySet()) {
                String currentValue;
                String name = "index." + (String)newSettingsEntry.getKey();
                if (forbiddenIndexSettings.contains((Object)name)) {
                    this.logger.warn("overriding the default [{}} setting is forbidden. ignoring...", new Object[]{name});
                    continue;
                }
                String newValue = (String)newSettingsEntry.getValue();
                if (newValue.equals(currentValue = existingSettings.get(name))) continue;
                changed = true;
                builder.put(name, newValue);
                this.logger.info("changing setting [{}] from [{}] to [{}]", new Object[]{name, currentValue, newValue});
            }
            if (!changed) continue;
            this.customIndexSettings = MapBuilder.newMapBuilder(this.customIndexSettings).put((Object)config.getSettingsPrefix(), (Object)builder.build()).immutableMap();
            this.putTemplate(config, false);
        }
    }

    private void putTemplate(final TemplateConfig config, boolean wait) {
        Executor executor = wait ? MoreExecutors.directExecutor() : this.threadPool.generic();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try (InputStream is = WatchStore.class.getResourceAsStream("/" + config.getTemplateName() + ".json");){
                    byte[] template;
                    if (is == null) {
                        WatcherIndexTemplateRegistry.this.logger.error("Resource [/" + config.getTemplateName() + ".json] not found in classpath", new Object[0]);
                        return;
                    }
                    try (BytesStreamOutput out = new BytesStreamOutput();){
                        Streams.copy((InputStream)is, (OutputStream)out);
                        template = out.bytes().toBytes();
                    }
                    PutIndexTemplateRequest request = new PutIndexTemplateRequest(config.getTemplateName()).source(template);
                    Settings customSettings = (Settings)WatcherIndexTemplateRegistry.this.customIndexSettings.get((Object)config.getSettingsPrefix());
                    if (customSettings != null && customSettings.names().size() > 0) {
                        Settings updatedSettings = Settings.builder().put(request.settings()).put(customSettings).build();
                        request.settings(updatedSettings);
                    }
                    PutIndexTemplateResponse putIndexTemplateResponse = WatcherIndexTemplateRegistry.this.client.putTemplate(request);
                }
                catch (Exception e) {
                    WatcherIndexTemplateRegistry.this.logger.error("failed to load [{}.json]", (Throwable)e, new Object[]{config.getTemplateName()});
                }
            }
        });
    }

    public static class TemplateConfig {
        private final String templateName;
        private final String settingsPrefix;

        public TemplateConfig(String templateName, String settingsPrefix) {
            this.templateName = templateName;
            this.settingsPrefix = settingsPrefix;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public String getSettingsPrefix() {
            return this.settingsPrefix;
        }

        public String getDynamicSettingsPrefix() {
            return this.settingsPrefix + ".*";
        }
    }
}

