/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support;

import org.elasticsearch.common.settings.Settings;

public abstract class ThreadPoolSettingsBuilder<B extends ThreadPoolSettingsBuilder> {
    protected final String name;
    private final Settings.Builder builder = Settings.builder();

    public static Same same(String name) {
        return new Same(name);
    }

    protected ThreadPoolSettingsBuilder(String name, String type) {
        this.name = name;
        this.put("type", type);
    }

    public Settings build() {
        return this.builder.build();
    }

    protected B put(String setting, Object value) {
        this.builder.put(new Object[]{"threadpool." + this.name + "." + setting, value});
        return (B)this;
    }

    protected B put(String setting, int value) {
        this.builder.put("threadpool." + this.name + "." + setting, value);
        return (B)this;
    }

    public static class Fixed
    extends ThreadPoolSettingsBuilder<Fixed> {
        public Fixed(String name) {
            super(name, "fixed");
        }

        public Fixed size(int size) {
            return (Fixed)this.put("size", size);
        }

        public Fixed queueSize(int queueSize) {
            return (Fixed)this.put("queue_size", queueSize);
        }
    }

    public static class Same
    extends ThreadPoolSettingsBuilder<Same> {
        public Same(String name) {
            super(name, "same");
        }
    }
}

