/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.ScriptService;

public class Script
implements ToXContent {
    public static final ScriptService.ScriptType DEFAULT_TYPE = ScriptService.ScriptType.INLINE;
    public static final String DEFAULT_LANG = "groovy";
    private final String script;
    @Nullable
    private final ScriptService.ScriptType type;
    @Nullable
    private final String lang;
    @Nullable
    private final Map<String, Object> params;

    Script(String script) {
        this(script, null, null, null);
    }

    Script(String script, @Nullable ScriptService.ScriptType type, @Nullable String lang, @Nullable Map<String, Object> params) {
        this.script = script;
        this.type = type;
        this.lang = lang;
        this.params = params;
    }

    public String script() {
        return this.script;
    }

    public ScriptService.ScriptType type() {
        return this.type != null ? this.type : ScriptService.ScriptType.INLINE;
    }

    public String lang() {
        return this.lang != null ? this.lang : DEFAULT_LANG;
    }

    public Map<String, Object> params() {
        return this.params != null ? this.params : Collections.EMPTY_MAP;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Script script1 = (Script)o;
        if (!this.script.equals(script1.script)) {
            return false;
        }
        if (this.type != script1.type) {
            return false;
        }
        if (this.lang != null ? !this.lang.equals(script1.lang) : script1.lang != null) {
            return false;
        }
        return !(this.params == null ? script1.params != null : !this.params.equals(script1.params));
    }

    public int hashCode() {
        int result = this.script.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.lang != null ? this.lang.hashCode() : 0);
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.type == null) {
            return builder.value(this.script);
        }
        builder.startObject();
        switch (this.type) {
            case INLINE: {
                builder.field(Field.INLINE.getPreferredName(), this.script);
                break;
            }
            case FILE: {
                builder.field(Field.FILE.getPreferredName(), this.script);
                break;
            }
            default: {
                assert (this.type == ScriptService.ScriptType.INDEXED) : "script type [" + this.type + "] is not supported";
                builder.field(Field.ID.getPreferredName(), this.script);
            }
        }
        if (this.lang != null) {
            builder.field(Field.LANG.getPreferredName(), this.lang);
        }
        if (this.params != null) {
            builder.field(Field.PARAMS.getPreferredName(), this.params);
        }
        return builder.endObject();
    }

    public static Script parse(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return new Script(parser.text());
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("expected a string value or an object, but found [{}] instead", new Object[]{token});
        }
        String script = null;
        ScriptService.ScriptType type = null;
        String lang = null;
        Map params = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.INLINE)) {
                type = ScriptService.ScriptType.INLINE;
                if (token == XContentParser.Token.VALUE_STRING) {
                    script = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("expected a string value for field [{}], but found [{}]", new Object[]{currentFieldName, token});
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.FILE)) {
                type = ScriptService.ScriptType.FILE;
                if (token == XContentParser.Token.VALUE_STRING) {
                    script = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("expected a string value for field [{}], but found [{}]", new Object[]{currentFieldName, token});
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ID)) {
                type = ScriptService.ScriptType.INDEXED;
                if (token == XContentParser.Token.VALUE_STRING) {
                    script = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("expected a string value for field [{}], but found [{}]", new Object[]{currentFieldName, token});
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.LANG)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    lang = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("expected a string value for field [{}], but found [{}]", new Object[]{currentFieldName, token});
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.PARAMS)) {
                if (token == XContentParser.Token.START_OBJECT) {
                    params = parser.map();
                    continue;
                }
                throw new ElasticsearchParseException("expected an object for field [{}], but found [{}]", new Object[]{currentFieldName, token});
            }
            throw new ElasticsearchParseException("unexpected field [{}]", new Object[]{currentFieldName});
        }
        if (script == null) {
            throw new ElasticsearchParseException("expected one of [{}], [{}] or [{}] fields, but found none", new Object[]{Field.INLINE.getPreferredName(), Field.FILE.getPreferredName(), Field.ID.getPreferredName()});
        }
        assert (type != null) : "if script is not null, type should definitely not be null";
        return new Script(script, type, lang, params);
    }

    public static Builder.Inline inline(String script) {
        return new Builder.Inline(script);
    }

    public static Builder.File file(String file) {
        return new Builder.File(file);
    }

    public static Builder.Indexed indexed(String id) {
        return new Builder.Indexed(id);
    }

    public static Builder.DefaultType defaultType(String text) {
        return new Builder.DefaultType(text);
    }

    static interface Field {
        public static final ParseField INLINE = new ParseField("inline", new String[0]);
        public static final ParseField FILE = new ParseField("file", new String[0]);
        public static final ParseField ID = new ParseField("id", new String[0]);
        public static final ParseField LANG = new ParseField("lang", new String[0]);
        public static final ParseField PARAMS = new ParseField("params", new String[0]);
    }

    public static abstract class Builder<B extends Builder> {
        protected final ScriptService.ScriptType type;
        protected final String script;
        protected String lang;
        protected Map<String, Object> params;

        protected Builder(String script, ScriptService.ScriptType type) {
            this.script = script;
            this.type = type;
        }

        public B lang(String lang) {
            this.lang = lang;
            return (B)this;
        }

        public B params(Map<String, Object> params) {
            this.params = params;
            return (B)this;
        }

        public abstract Script build();

        public static class DefaultType
        extends Builder<DefaultType> {
            public DefaultType(String text) {
                super(text, null);
            }

            @Override
            public Script build() {
                return new Script(this.script, this.type, this.lang, this.params);
            }
        }

        public static class Indexed
        extends Builder<Indexed> {
            public Indexed(String id) {
                super(id, ScriptService.ScriptType.INDEXED);
            }

            @Override
            public Script build() {
                return new Script(this.script, this.type, this.lang, this.params);
            }
        }

        public static class File
        extends Builder<File> {
            public File(String file) {
                super(file, ScriptService.ScriptType.FILE);
            }

            @Override
            public Script build() {
                return new Script(this.script, this.type, this.lang, this.params);
            }
        }

        public static class Inline
        extends Builder<Inline> {
            public Inline(String script) {
                super(script, ScriptService.ScriptType.INLINE);
            }

            @Override
            public Script build() {
                return new Script(this.script, this.type, this.lang, this.params);
            }
        }
    }
}

