/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.shield;

import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.crypto.CryptoService;
import org.elasticsearch.watcher.support.secret.SecretService;

public class ShieldSecretService
extends AbstractComponent
implements SecretService {
    private final CryptoService cryptoService;
    private final boolean encryptSensitiveData;

    @Inject
    public ShieldSecretService(Settings settings, CryptoService cryptoService) {
        super(settings);
        this.encryptSensitiveData = settings.getAsBoolean("watcher.shield.encrypt_sensitive_data", Boolean.valueOf(false));
        this.cryptoService = cryptoService;
    }

    @Override
    public char[] encrypt(char[] text) {
        return this.encryptSensitiveData ? this.cryptoService.encrypt(text) : text;
    }

    @Override
    public char[] decrypt(char[] text) {
        return this.encryptSensitiveData ? this.cryptoService.decrypt(text) : text;
    }
}

