/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.rest.action;

import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.watcher.client.WatcherClient;
import org.elasticsearch.watcher.rest.WatcherRestHandler;
import org.elasticsearch.watcher.transport.actions.stats.WatcherStatsRequest;
import org.elasticsearch.watcher.transport.actions.stats.WatcherStatsResponse;

public class RestWatcherInfoAction
extends WatcherRestHandler {
    @Inject
    public RestWatcherInfoAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, URI_BASE, (RestHandler)this);
    }

    @Override
    protected void handleRequest(RestRequest request, RestChannel restChannel, WatcherClient client) throws Exception {
        client.watcherStats(new WatcherStatsRequest(), (ActionListener<WatcherStatsResponse>)new RestBuilderListener<WatcherStatsResponse>(restChannel){

            public RestResponse buildResponse(WatcherStatsResponse watcherStatsResponse, XContentBuilder builder) throws Exception {
                builder.startObject().startObject("version").field("number", Version.CURRENT.number()).field("build_hash", watcherStatsResponse.getBuild().hash()).field("build_timestamp", watcherStatsResponse.getBuild().timestamp()).field("build_snapshot", (Object)Version.CURRENT.snapshot).endObject().field("tagline", "You Know, for Alerts & Automation").endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

