/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.rest.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.AcknowledgedRestListener;
import org.elasticsearch.watcher.client.WatcherClient;
import org.elasticsearch.watcher.rest.WatcherRestHandler;
import org.elasticsearch.watcher.transport.actions.service.WatcherServiceRequest;
import org.elasticsearch.watcher.transport.actions.service.WatcherServiceResponse;

public class RestWatchServiceAction
extends WatcherRestHandler {
    @Inject
    public RestWatchServiceAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.PUT, URI_BASE + "/_restart", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, URI_BASE + "/_start", (RestHandler)new StartRestHandler(settings, controller, client));
        controller.registerHandler(RestRequest.Method.PUT, URI_BASE + "/_stop", (RestHandler)new StopRestHandler(settings, controller, client));
    }

    @Override
    protected void handleRequest(RestRequest request, RestChannel channel, WatcherClient client) throws Exception {
        client.watcherService(new WatcherServiceRequest().restart(), (ActionListener<WatcherServiceResponse>)new AcknowledgedRestListener(channel));
    }

    static class StopRestHandler
    extends WatcherRestHandler {
        public StopRestHandler(Settings settings, RestController controller, Client client) {
            super(settings, controller, client);
        }

        @Override
        protected void handleRequest(RestRequest request, RestChannel channel, WatcherClient client) throws Exception {
            client.watcherService(new WatcherServiceRequest().stop(), (ActionListener<WatcherServiceResponse>)new AcknowledgedRestListener(channel));
        }
    }

    static class StartRestHandler
    extends WatcherRestHandler {
        public StartRestHandler(Settings settings, RestController controller, Client client) {
            super(settings, controller, client);
        }

        @Override
        protected void handleRequest(RestRequest request, RestChannel channel, WatcherClient client) throws Exception {
            client.watcherService(new WatcherServiceRequest().start(), (ActionListener<WatcherServiceResponse>)new AcknowledgedRestListener(channel));
        }
    }
}

