/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.rest.action;

import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.watcher.client.WatcherClient;
import org.elasticsearch.watcher.rest.WatcherRestHandler;

public class RestHijackOperationAction
extends WatcherRestHandler {
    private static String ALLOW_DIRECT_ACCESS_TO_WATCH_INDEX_SETTING = "watcher.index.rest.direct_access";

    @Inject
    public RestHijackOperationAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        if (!settings.getAsBoolean(ALLOW_DIRECT_ACCESS_TO_WATCH_INDEX_SETTING, Boolean.valueOf(false)).booleanValue()) {
            UnsupportedHandler unsupportedHandler = new UnsupportedHandler(settings, controller, client);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch/{id}", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.PUT, ".watches/watch/{id}", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch/{id}/_update", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.DELETE, ".watches/watch/_query", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.DELETE, ".watches/watch/{id}", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.GET, ".watches/watch/{id}", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch/_bulk", (RestHandler)unsupportedHandler);
            controller.registerHandler(RestRequest.Method.POST, ".watches/_bulk", (RestHandler)unsupportedHandler);
            controller.registerHandler(RestRequest.Method.PUT, ".watches/watch/_bulk", (RestHandler)unsupportedHandler);
            controller.registerHandler(RestRequest.Method.PUT, ".watches/_bulk", (RestHandler)unsupportedHandler);
            controller.registerHandler(RestRequest.Method.DELETE, ".watches", (RestHandler)unsupportedHandler);
        }
    }

    @Override
    protected void handleRequest(RestRequest request, RestChannel channel, WatcherClient client) throws Exception {
        XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
        jsonBuilder.startObject().field("error", "This endpoint is not supported for " + request.method().name() + " on " + ".watches" + " index. Please use " + request.method().name() + " " + URI_BASE + "/watch/<watch_id> instead");
        jsonBuilder.field("status", RestStatus.BAD_REQUEST.getStatus());
        jsonBuilder.endObject();
        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, jsonBuilder));
    }

    public static class UnsupportedHandler
    extends WatcherRestHandler {
        public UnsupportedHandler(Settings settings, RestController controller, Client client) {
            super(settings, controller, client);
        }

        @Override
        protected void handleRequest(RestRequest request, RestChannel channel, WatcherClient client) throws Exception {
            request.path();
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
            jsonBuilder.startObject().field("error", "This endpoint is not supported for " + request.method().name() + " on " + ".watches" + " index.");
            jsonBuilder.field("status", RestStatus.BAD_REQUEST.getStatus());
            jsonBuilder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, jsonBuilder));
        }
    }
}

