/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.rest.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.watcher.client.WatcherClient;
import org.elasticsearch.watcher.rest.WatcherRestHandler;
import org.elasticsearch.watcher.transport.actions.delete.DeleteWatchRequest;
import org.elasticsearch.watcher.transport.actions.delete.DeleteWatchResponse;

public class RestDeleteWatchAction
extends WatcherRestHandler {
    @Inject
    public RestDeleteWatchAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.DELETE, URI_BASE + "/watch/{id}", (RestHandler)this);
    }

    @Override
    protected void handleRequest(RestRequest request, RestChannel channel, WatcherClient client) throws Exception {
        DeleteWatchRequest deleteWatchRequest = new DeleteWatchRequest(request.param("id"));
        deleteWatchRequest.masterNodeTimeout(request.paramAsTime("master_timeout", deleteWatchRequest.masterNodeTimeout()));
        deleteWatchRequest.setForce(request.paramAsBoolean("force", deleteWatchRequest.isForce()));
        client.deleteWatch(deleteWatchRequest, (ActionListener<DeleteWatchResponse>)new RestBuilderListener<DeleteWatchResponse>(channel){

            public RestResponse buildResponse(DeleteWatchResponse response, XContentBuilder builder) throws Exception {
                builder.startObject().field("_id", response.getId()).field("_version", response.getVersion()).field("found", response.isFound()).endObject();
                RestStatus status = response.isFound() ? RestStatus.OK : RestStatus.NOT_FOUND;
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

