/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.input.search;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.input.Input;
import org.elasticsearch.watcher.input.search.ExecutableSearchInput;
import org.elasticsearch.watcher.support.SearchRequestEquivalence;
import org.elasticsearch.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.watcher.support.WatcherUtils;
import org.elasticsearch.watcher.watch.Payload;
import org.joda.time.DateTimeZone;

public class SearchInput
implements Input {
    public static final String TYPE = "search";
    private final SearchRequest searchRequest;
    @Nullable
    private final Set<String> extractKeys;
    @Nullable
    private final TimeValue timeout;
    @Nullable
    private final DateTimeZone dynamicNameTimeZone;

    public SearchInput(SearchRequest searchRequest, @Nullable Set<String> extractKeys, @Nullable TimeValue timeout, @Nullable DateTimeZone dynamicNameTimeZone) {
        this.searchRequest = searchRequest;
        this.extractKeys = extractKeys;
        this.timeout = timeout;
        this.dynamicNameTimeZone = dynamicNameTimeZone;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchInput that = (SearchInput)o;
        if (!SearchRequestEquivalence.INSTANCE.equivalent(this.searchRequest, this.searchRequest)) {
            return false;
        }
        if (this.extractKeys != null ? !this.extractKeys.equals(that.extractKeys) : that.extractKeys != null) {
            return false;
        }
        if (this.timeout != null ? !this.timeout.equals((Object)that.timeout) : that.timeout != null) {
            return false;
        }
        return !(this.dynamicNameTimeZone == null ? that.dynamicNameTimeZone != null : !this.dynamicNameTimeZone.equals((Object)that.dynamicNameTimeZone));
    }

    public int hashCode() {
        int result = this.searchRequest.hashCode();
        result = 31 * result + (this.extractKeys != null ? this.extractKeys.hashCode() : 0);
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        result = 31 * result + (this.dynamicNameTimeZone != null ? this.dynamicNameTimeZone.hashCode() : 0);
        return result;
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public Set<String> getExtractKeys() {
        return this.extractKeys;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public DateTimeZone getDynamicNameTimeZone() {
        return this.dynamicNameTimeZone;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.REQUEST.getPreferredName());
        builder = WatcherUtils.writeSearchRequest(this.searchRequest, builder, params);
        if (this.extractKeys != null) {
            builder.field(Field.EXTRACT.getPreferredName(), this.extractKeys);
        }
        if (this.timeout != null) {
            builder.field(Field.TIMEOUT.getPreferredName(), (Object)this.timeout);
        }
        if (this.dynamicNameTimeZone != null) {
            builder.field(Field.DYNAMIC_NAME_TIMEZONE.getPreferredName(), (Object)this.dynamicNameTimeZone);
        }
        builder.endObject();
        return builder;
    }

    public static SearchInput parse(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        SearchRequest request = null;
        HashSet<String> extract = null;
        TimeValue timeout = null;
        DateTimeZone dynamicNameTimeZone = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.REQUEST)) {
                try {
                    request = WatcherUtils.readSearchRequest(parser, ExecutableSearchInput.DEFAULT_SEARCH_TYPE);
                    continue;
                }
                catch (ElasticsearchParseException srpe) {
                    throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. failed to parse [{}]", (Throwable)srpe, new Object[]{TYPE, watchId, currentFieldName});
                }
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.EXTRACT)) {
                    extract = new HashSet<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            extract.add(parser.text());
                            continue;
                        }
                        throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. expected a string value in [{}] array, but found [{}] instead", new Object[]{TYPE, watchId, currentFieldName, token});
                    }
                    continue;
                }
                throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. unexpected array field [{}]", new Object[]{TYPE, watchId, currentFieldName});
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.TIMEOUT)) {
                timeout = WatcherDateTimeUtils.parseTimeValue(parser, Field.TIMEOUT.toString());
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.DYNAMIC_NAME_TIMEZONE)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    dynamicNameTimeZone = DateTimeZone.forID((String)parser.text());
                    continue;
                }
                throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. failed to parse [{}]. must be a string value (e.g. 'UTC' or '+01:00').", new Object[]{TYPE, watchId, currentFieldName});
            }
            throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. unexpected token [{}]", new Object[]{TYPE, watchId, token});
        }
        if (request == null) {
            throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. missing required [{}] field", new Object[]{TYPE, watchId, Field.REQUEST.getPreferredName()});
        }
        return new SearchInput(request, extract, timeout, dynamicNameTimeZone);
    }

    public static Builder builder(SearchRequest request) {
        return new Builder(request);
    }

    public static interface Field
    extends Input.Field {
        public static final ParseField REQUEST = new ParseField("request", new String[0]);
        public static final ParseField EXTRACT = new ParseField("extract", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField DYNAMIC_NAME_TIMEZONE = new ParseField("dynamic_name_timezone", new String[0]);
    }

    public static class Builder
    implements Input.Builder<SearchInput> {
        private final SearchRequest request;
        private final ImmutableSet.Builder<String> extractKeys = ImmutableSet.builder();
        private TimeValue timeout;
        private DateTimeZone dynamicNameTimeZone;

        private Builder(SearchRequest request) {
            this.request = request;
        }

        public Builder extractKeys(Collection<String> keys) {
            this.extractKeys.addAll(keys);
            return this;
        }

        public Builder extractKeys(String ... keys) {
            this.extractKeys.add((Object[])keys);
            return this;
        }

        public Builder timeout(TimeValue readTimeout) {
            this.timeout = readTimeout;
            return this;
        }

        public Builder dynamicNameTimeZone(DateTimeZone dynamicNameTimeZone) {
            this.dynamicNameTimeZone = dynamicNameTimeZone;
            return this;
        }

        @Override
        public SearchInput build() {
            ImmutableSet keys = this.extractKeys.build();
            return new SearchInput(this.request, (Set<String>)(keys.isEmpty() ? null : keys), this.timeout, this.dynamicNameTimeZone);
        }
    }

    public static class Result
    extends Input.Result {
        @Nullable
        private final SearchRequest request;

        public Result(SearchRequest request, Payload payload) {
            super(SearchInput.TYPE, payload);
            this.request = request;
        }

        public Result(@Nullable SearchRequest request, Exception e) {
            super(SearchInput.TYPE, e);
            this.request = request;
        }

        public SearchRequest executedRequest() {
            return this.request;
        }

        @Override
        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.request == null) {
                return builder;
            }
            builder.startObject(this.type);
            builder.field(Field.REQUEST.getPreferredName());
            WatcherUtils.writeSearchRequest(this.request, builder, params);
            return builder.endObject();
        }
    }
}

