/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.input.http;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.input.InputFactory;
import org.elasticsearch.watcher.input.http.ExecutableHttpInput;
import org.elasticsearch.watcher.input.http.HttpInput;
import org.elasticsearch.watcher.support.http.HttpClient;
import org.elasticsearch.watcher.support.http.HttpRequest;
import org.elasticsearch.watcher.support.http.HttpRequestTemplate;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;

public final class HttpInputFactory
extends InputFactory<HttpInput, HttpInput.Result, ExecutableHttpInput> {
    private final HttpClient httpClient;
    private final TextTemplateEngine templateEngine;
    private final HttpRequest.Parser requestParser;
    private final HttpRequestTemplate.Parser requestTemplateParser;

    @Inject
    public HttpInputFactory(Settings settings, HttpClient httpClient, TextTemplateEngine templateEngine, HttpRequest.Parser requestParser, HttpRequestTemplate.Parser requestTemplateParser) {
        super(Loggers.getLogger(ExecutableHttpInput.class, (Settings)settings, (String[])new String[0]));
        this.templateEngine = templateEngine;
        this.httpClient = httpClient;
        this.requestParser = requestParser;
        this.requestTemplateParser = requestTemplateParser;
    }

    @Override
    public String type() {
        return "http";
    }

    @Override
    public HttpInput parseInput(String watchId, XContentParser parser) throws IOException {
        return HttpInput.parse(watchId, parser, this.requestTemplateParser);
    }

    @Override
    public ExecutableHttpInput createExecutable(HttpInput input) {
        return new ExecutableHttpInput(input, this.inputLogger, this.httpClient, this.templateEngine);
    }
}

