/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.input.http;

import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.input.ExecutableInput;
import org.elasticsearch.watcher.input.http.HttpInput;
import org.elasticsearch.watcher.support.Variables;
import org.elasticsearch.watcher.support.XContentFilterKeysUtils;
import org.elasticsearch.watcher.support.http.HttpClient;
import org.elasticsearch.watcher.support.http.HttpRequest;
import org.elasticsearch.watcher.support.http.HttpResponse;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;
import org.elasticsearch.watcher.watch.Payload;

public class ExecutableHttpInput
extends ExecutableInput<HttpInput, HttpInput.Result> {
    private final HttpClient client;
    private final TextTemplateEngine templateEngine;

    public ExecutableHttpInput(HttpInput input, ESLogger logger, HttpClient client, TextTemplateEngine templateEngine) {
        super(input, logger);
        this.client = client;
        this.templateEngine = templateEngine;
    }

    @Override
    public HttpInput.Result execute(WatchExecutionContext ctx, Payload payload) {
        HttpRequest request = null;
        try {
            Map<String, Object> model = Variables.createCtxModel(ctx, payload);
            request = ((HttpInput)this.input).getRequest().render(this.templateEngine, model);
            return this.doExecute(ctx, request);
        }
        catch (Exception e) {
            this.logger.error("failed to execute [{}] input for [{}]", (Throwable)e, new Object[]{"http", ctx.watch()});
            return new HttpInput.Result(request, e);
        }
    }

    HttpInput.Result doExecute(WatchExecutionContext ctx, HttpRequest request) throws Exception {
        Payload.Simple payload;
        HttpResponse response = this.client.execute(request);
        if (!response.hasContent()) {
            return new HttpInput.Result(request, response.status(), Payload.EMPTY);
        }
        XContentType contentType = response.xContentType();
        if (((HttpInput)this.input).getExpectedResponseXContentType() != null) {
            if (contentType != ((HttpInput)this.input).getExpectedResponseXContentType().contentType()) {
                this.logger.warn("[{}] [{}] input expected content type [{}] but read [{}] from headers", new Object[]{this.type(), ctx.id(), ((HttpInput)this.input).getExpectedResponseXContentType(), contentType});
            }
            if (contentType == null) {
                contentType = ((HttpInput)this.input).getExpectedResponseXContentType().contentType();
            }
        } else if (contentType == null) {
            contentType = XContentFactory.xContentType((BytesReference)response.body());
        }
        XContentParser parser = null;
        if (contentType != null) {
            try {
                parser = contentType.xContent().createParser(response.body());
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("could not parse response body [{}] it does not appear to be [{}]", new Object[]{this.type(), ctx.id(), response.body().toUtf8(), contentType.shortName()});
            }
        }
        if (((HttpInput)this.input).getExtractKeys() != null) {
            Map<String, Object> filteredKeys = XContentFilterKeysUtils.filterMapOrdered(((HttpInput)this.input).getExtractKeys(), parser);
            payload = new Payload.Simple(filteredKeys);
        } else if (parser != null) {
            Map map = parser.mapOrdered();
            payload = new Payload.Simple(map);
        } else {
            payload = new Payload.Simple("_value", response.body().toUtf8());
        }
        return new HttpInput.Result(request, response.status(), payload);
    }
}

