/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.input.chain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.input.ExecutableInput;
import org.elasticsearch.watcher.input.Input;
import org.elasticsearch.watcher.input.chain.ChainInput;
import org.elasticsearch.watcher.watch.Payload;

public class ExecutableChainInput
extends ExecutableInput<ChainInput, ChainInput.Result> {
    private List<Tuple<String, ExecutableInput>> inputs;

    public ExecutableChainInput(ChainInput input, List<Tuple<String, ExecutableInput>> inputs, ESLogger logger) {
        super(input, logger);
        this.inputs = inputs;
    }

    @Override
    public ChainInput.Result execute(WatchExecutionContext ctx, Payload payload) {
        ArrayList<Tuple<String, Input.Result>> results = new ArrayList<Tuple<String, Input.Result>>();
        HashMap<String, Object> payloads = new HashMap<String, Object>();
        try {
            for (Tuple<String, ExecutableInput> tuple : this.inputs) {
                Object result = ((ExecutableInput)tuple.v2()).execute(ctx, new Payload.Simple(payloads));
                results.add((Tuple<String, Input.Result>)new Tuple(tuple.v1(), result));
                payloads.put((String)tuple.v1(), ((Input.Result)result).payload().data());
            }
            return new ChainInput.Result(results, (Payload)new Payload.Simple(payloads));
        }
        catch (Exception e) {
            this.logger.error("failed to execute [{}] input for [{}]", (Throwable)e, new Object[]{"chain", ctx.watch()});
            return new ChainInput.Result(e);
        }
    }
}

