/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.input.chain;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.input.ExecutableInput;
import org.elasticsearch.watcher.input.Input;
import org.elasticsearch.watcher.input.InputFactory;
import org.elasticsearch.watcher.input.InputRegistry;
import org.elasticsearch.watcher.input.chain.ChainInput;
import org.elasticsearch.watcher.input.chain.ExecutableChainInput;
import org.elasticsearch.watcher.support.init.InitializingService;

public class ChainInputFactory
extends InputFactory<ChainInput, ChainInput.Result, ExecutableChainInput>
implements InitializingService.Initializable {
    private InputRegistry inputRegistry;

    @Inject
    public ChainInputFactory(Settings settings) {
        super(Loggers.getLogger(ExecutableChainInput.class, (Settings)settings, (String[])new String[0]));
    }

    @Override
    public String type() {
        return "chain";
    }

    @Override
    public ChainInput parseInput(String watchId, XContentParser parser) throws IOException {
        return ChainInput.parse(watchId, parser, this.inputRegistry);
    }

    @Override
    public ExecutableChainInput createExecutable(ChainInput input) {
        ArrayList<Tuple<String, ExecutableInput>> executableInputs = new ArrayList<Tuple<String, ExecutableInput>>();
        for (Tuple<String, Input> tuple : input.getInputs()) {
            Object executableInput = this.inputRegistry.factories().get(((Input)tuple.v2()).type()).createExecutable((Input)tuple.v2());
            executableInputs.add((Tuple<String, ExecutableInput>)new Tuple(tuple.v1(), executableInput));
        }
        return new ExecutableChainInput(input, executableInputs, this.inputLogger);
    }

    @Override
    public void init(Injector injector) {
        this.init((InputRegistry)injector.getInstance(InputRegistry.class));
    }

    void init(InputRegistry inputRegistry) {
        this.inputRegistry = inputRegistry;
    }
}

