/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.input;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.watcher.input.InputFactory;
import org.elasticsearch.watcher.input.InputRegistry;
import org.elasticsearch.watcher.input.chain.ChainInputFactory;
import org.elasticsearch.watcher.input.http.HttpInputFactory;
import org.elasticsearch.watcher.input.none.NoneInputFactory;
import org.elasticsearch.watcher.input.search.SearchInputFactory;
import org.elasticsearch.watcher.input.simple.SimpleInputFactory;

public class InputModule
extends AbstractModule {
    private final Map<String, Class<? extends InputFactory>> parsers = new HashMap<String, Class<? extends InputFactory>>();

    public void registerInput(String type, Class<? extends InputFactory> parserType) {
        this.parsers.put(type, parserType);
    }

    protected void configure() {
        MapBinder parsersBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, InputFactory.class);
        this.bind(SearchInputFactory.class).asEagerSingleton();
        parsersBinder.addBinding((Object)"search").to(SearchInputFactory.class);
        this.bind(SimpleInputFactory.class).asEagerSingleton();
        parsersBinder.addBinding((Object)"simple").to(SimpleInputFactory.class);
        this.bind(HttpInputFactory.class).asEagerSingleton();
        parsersBinder.addBinding((Object)"http").to(HttpInputFactory.class);
        this.bind(NoneInputFactory.class).asEagerSingleton();
        parsersBinder.addBinding((Object)"none").to(NoneInputFactory.class);
        parsersBinder.addBinding((Object)"chain").to(ChainInputFactory.class);
        for (Map.Entry<String, Class<? extends InputFactory>> entry : this.parsers.entrySet()) {
            this.bind(entry.getValue()).asEagerSingleton();
            parsersBinder.addBinding((Object)entry.getKey()).to(entry.getValue());
        }
        this.bind(InputRegistry.class).asEagerSingleton();
    }
}

