/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.execution;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.watcher.actions.Action;
import org.elasticsearch.watcher.actions.ActionWrapper;
import org.elasticsearch.watcher.condition.Condition;
import org.elasticsearch.watcher.execution.ActionExecutionMode;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.input.Input;
import org.elasticsearch.watcher.trigger.manual.ManualTriggerEvent;
import org.elasticsearch.watcher.watch.Watch;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ManualExecutionContext
extends WatchExecutionContext {
    private final Map<String, ActionExecutionMode> actionModes;
    private final boolean recordExecution;
    private final boolean knownWatch;

    ManualExecutionContext(Watch watch, boolean knownWatch, DateTime executionTime, ManualTriggerEvent triggerEvent, TimeValue defaultThrottlePeriod, Input.Result inputResult, Condition.Result conditionResult, Map<String, ActionExecutionMode> actionModes, boolean recordExecution) {
        super(watch, executionTime, triggerEvent, defaultThrottlePeriod);
        ActionExecutionMode allMode;
        this.actionModes = actionModes;
        this.recordExecution = recordExecution;
        this.knownWatch = knownWatch;
        if (inputResult != null) {
            this.onInputResult(inputResult);
        }
        if (conditionResult != null) {
            this.onConditionResult(conditionResult);
        }
        if ((allMode = actionModes.get("_all")) == null || allMode == ActionExecutionMode.SKIP) {
            boolean throttleAll = allMode == ActionExecutionMode.SKIP;
            for (ActionWrapper action : watch.actions()) {
                if (throttleAll) {
                    this.onActionResult(new ActionWrapper.Result(action.id(), new Action.Result.Throttled(action.action().type(), "manually skipped")));
                    continue;
                }
                ActionExecutionMode mode = actionModes.get(action.id());
                if (mode != ActionExecutionMode.SKIP) continue;
                this.onActionResult(new ActionWrapper.Result(action.id(), new Action.Result.Throttled(action.action().type(), "manually skipped")));
            }
        }
    }

    @Override
    public boolean knownWatch() {
        return this.knownWatch;
    }

    @Override
    public final boolean simulateAction(String actionId) {
        ActionExecutionMode mode = this.actionModes.get("_all");
        if (mode == null) {
            mode = this.actionModes.get(actionId);
        }
        return mode != null && mode.simulate();
    }

    @Override
    public boolean skipThrottling(String actionId) {
        ActionExecutionMode mode = this.actionModes.get("_all");
        if (mode == null) {
            mode = this.actionModes.get(actionId);
        }
        return mode != null && mode.force();
    }

    @Override
    public final boolean recordExecution() {
        return this.recordExecution;
    }

    public static Builder builder(Watch watch, boolean knownWatch, ManualTriggerEvent event, TimeValue defaultThrottlePeriod) {
        return new Builder(watch, knownWatch, event, defaultThrottlePeriod);
    }

    public static class Builder {
        static final String ALL = "_all";
        private final Watch watch;
        private final boolean knownWatch;
        private final ManualTriggerEvent triggerEvent;
        private final TimeValue defaultThrottlePeriod;
        protected DateTime executionTime;
        private boolean recordExecution = false;
        private ImmutableMap.Builder<String, ActionExecutionMode> actionModes = ImmutableMap.builder();
        private Input.Result inputResult;
        private Condition.Result conditionResult;

        private Builder(Watch watch, boolean knownWatch, ManualTriggerEvent triggerEvent, TimeValue defaultThrottlePeriod) {
            this.watch = watch;
            this.knownWatch = knownWatch;
            assert (triggerEvent != null);
            this.triggerEvent = triggerEvent;
            this.defaultThrottlePeriod = defaultThrottlePeriod;
        }

        public Builder executionTime(DateTime executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public Builder recordExecution(boolean recordExecution) {
            this.recordExecution = recordExecution;
            return this;
        }

        public Builder allActionsMode(ActionExecutionMode mode) {
            return this.actionMode(ALL, mode);
        }

        public Builder actionMode(String id, ActionExecutionMode mode) {
            if (ALL.equals(id)) {
                this.actionModes = ImmutableMap.builder();
            }
            this.actionModes.put((Object)id, (Object)mode);
            return this;
        }

        public Builder withInput(Input.Result inputResult) {
            this.inputResult = inputResult;
            return this;
        }

        public Builder withCondition(Condition.Result conditionResult) {
            this.conditionResult = conditionResult;
            return this;
        }

        public ManualExecutionContext build() {
            if (this.executionTime == null) {
                this.executionTime = DateTime.now((DateTimeZone)DateTimeZone.UTC);
            }
            return new ManualExecutionContext(this.watch, this.knownWatch, this.executionTime, this.triggerEvent, this.defaultThrottlePeriod, this.inputResult, this.conditionResult, (Map<String, ActionExecutionMode>)this.actionModes.build(), this.recordExecution);
        }
    }
}

