/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.execution;

import java.util.concurrent.BlockingQueue;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.execution.WatchExecutor;
import org.elasticsearch.watcher.support.ThreadPoolSettingsBuilder;

public class InternalWatchExecutor
implements WatchExecutor {
    public static final String THREAD_POOL_NAME = "watcher";
    private final ThreadPool threadPool;

    public static Settings additionalSettings(Settings nodeSettings) {
        Settings settings = nodeSettings.getAsSettings("threadpool.watcher");
        if (!settings.names().isEmpty()) {
            return Settings.EMPTY;
        }
        int availableProcessors = EsExecutors.boundedNumberOfProcessors((Settings)nodeSettings);
        return new ThreadPoolSettingsBuilder.Fixed(THREAD_POOL_NAME).size(5 * availableProcessors).queueSize(1000).build();
    }

    @Inject
    public InternalWatchExecutor(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public BlockingQueue<Runnable> queue() {
        return this.executor().getQueue();
    }

    @Override
    public long largestPoolSize() {
        return this.executor().getLargestPoolSize();
    }

    @Override
    public void execute(Runnable runnable) {
        this.executor().execute(runnable);
    }

    private EsThreadPoolExecutor executor() {
        return (EsThreadPoolExecutor)this.threadPool.executor(THREAD_POOL_NAME);
    }
}

