/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.execution;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.watcher.execution.ExecutionService;
import org.elasticsearch.watcher.support.Exceptions;

public class CurrentExecutions
implements Iterable<ExecutionService.WatchExecution> {
    private final ConcurrentMap<String, ExecutionService.WatchExecution> currentExecutions = new ConcurrentHashMap<String, ExecutionService.WatchExecution>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition empty = this.lock.newCondition();
    private boolean seal = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String id, ExecutionService.WatchExecution execution) {
        this.lock.lock();
        try {
            if (this.seal) {
                throw Exceptions.illegalState("could not register execution [{}]. current executions are sealed and forbid registrations of additional executions.", id);
            }
            this.currentExecutions.put(id, execution);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) {
        this.lock.lock();
        try {
            this.currentExecutions.remove(id);
            if (this.currentExecutions.isEmpty()) {
                this.empty.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sealAndAwaitEmpty(TimeValue maxStopTimeout) {
        this.lock.lock();
        try {
            this.seal = true;
            while (this.currentExecutions.size() > 0) {
                this.empty.await(maxStopTimeout.millis(), TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<ExecutionService.WatchExecution> iterator() {
        return this.currentExecutions.values().iterator();
    }
}

