/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition.script;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.condition.ConditionFactory;
import org.elasticsearch.watcher.condition.script.ExecutableScriptCondition;
import org.elasticsearch.watcher.condition.script.ScriptCondition;
import org.elasticsearch.watcher.support.init.proxy.ScriptServiceProxy;

public class ScriptConditionFactory
extends ConditionFactory<ScriptCondition, ScriptCondition.Result, ExecutableScriptCondition> {
    private final ScriptServiceProxy scriptService;

    @Inject
    public ScriptConditionFactory(Settings settings, ScriptServiceProxy service) {
        super(Loggers.getLogger(ExecutableScriptCondition.class, (Settings)settings, (String[])new String[0]));
        this.scriptService = service;
    }

    @Override
    public String type() {
        return "script";
    }

    @Override
    public ScriptCondition parseCondition(String watchId, XContentParser parser) throws IOException {
        return ScriptCondition.parse(watchId, parser);
    }

    @Override
    public ExecutableScriptCondition createExecutable(ScriptCondition condition) {
        return new ExecutableScriptCondition(condition, this.conditionLogger, this.scriptService);
    }
}

