/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition.compare.array;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.condition.ConditionFactory;
import org.elasticsearch.watcher.condition.compare.array.ArrayCompareCondition;
import org.elasticsearch.watcher.condition.compare.array.ExecutableArrayCompareCondition;
import org.elasticsearch.watcher.support.clock.Clock;

public class ArrayCompareConditionFactory
extends ConditionFactory<ArrayCompareCondition, ArrayCompareCondition.Result, ExecutableArrayCompareCondition> {
    private final Clock clock;

    @Inject
    public ArrayCompareConditionFactory(Settings settings, Clock clock) {
        super(Loggers.getLogger(ExecutableArrayCompareCondition.class, (Settings)settings, (String[])new String[0]));
        this.clock = clock;
    }

    @Override
    public String type() {
        return "array_compare";
    }

    @Override
    public ArrayCompareCondition parseCondition(String watchId, XContentParser parser) throws IOException {
        return ArrayCompareCondition.parse(watchId, parser);
    }

    @Override
    public ExecutableArrayCompareCondition createExecutable(ArrayCompareCondition condition) {
        return new ExecutableArrayCompareCondition(condition, this.conditionLogger, this.clock);
    }
}

